/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.schema.hl7;

import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.lexical.formats.ExplicitDecimalFormat;
import com.mulesoft.flatfile.lexical.formats.GeneralStringFormat;
import com.mulesoft.flatfile.lexical.formats.IntegerFormat;
import com.mulesoft.flatfile.lexical.formats.XmlDateFormat;
import com.mulesoft.flatfile.schema.hl7generic.VariesFormat;

public final class HL7Formats$ {
    public static HL7Formats$ MODULE$;

    static {
        new HL7Formats$();
    }

    public TypeFormat buildType(String typ, int minLength, int maxLength) {
        Object object;
        String string = typ.toUpperCase();
        if ("ST".equals(string)) {
            object = new GeneralStringFormat(typ, minLength, maxLength, TypeFormatConstants.FillMode.LEFT);
        } else if ("NM".equals(string)) {
            object = new ExplicitDecimalFormat(typ, minLength, maxLength, TypeFormatConstants.NumberSign.OPTIONAL, true, TypeFormatConstants.FillMode.ZEROES, true, false, false, false);
        } else if ("SI".equals(string)) {
            object = new IntegerFormat(typ, minLength, maxLength, TypeFormatConstants.NumberSign.UNSIGNED, false, TypeFormatConstants.FillMode.ZEROES);
        } else if ("DT".equals(string)) {
            object = new XmlDateFormat(typ, minLength, maxLength, XmlDateFormat.Variation.DATE);
        } else if ("DTM".equals(string)) {
            object = new XmlDateFormat(typ, minLength, maxLength, XmlDateFormat.Variation.DATETIME);
        } else if ("TM".equals(string)) {
            object = new XmlDateFormat(typ, minLength, maxLength, XmlDateFormat.Variation.TIME);
        } else {
            boolean bl = "VARIES".equals(string) ? true : "VAR".equals(string);
            if (bl) {
                object = new VariesFormat(minLength, maxLength);
            } else {
                boolean bl2 = "FT".equals(string) ? true : ("GTS".equals(string) ? true : ("ID".equals(string) ? true : ("IS".equals(string) ? true : ("SNM".equals(string) ? true : ("TN".equals(string) ? true : "TX".equals(string))))));
                if (bl2) {
                    object = new GeneralStringFormat(typ, minLength, maxLength, TypeFormatConstants.FillMode.LEFT);
                } else {
                    throw new IllegalArgumentException(new StringBuilder(22).append("Unknown HL7 type code ").append(typ).toString());
                }
            }
        }
        return object;
    }

    private HL7Formats$() {
        MODULE$ = this;
    }
}

