/*
 * Decompiled with CFR 0.152.
 */
package spire.math.poly;

import java.io.Serializable;
import java.math.BigDecimal;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.math.BigInt;
import scala.math.Ordering$Int$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichDouble$;
import spire.math.Interval;
import spire.math.Polynomial;
import spire.math.Polynomial$;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.SafeLong$;
import spire.math.package$;
import spire.math.poly.RootIsolator;
import spire.math.poly.Term;
import spire.std.package$bigDecimal$;
import spire.std.package$bigInt$;

public final class Roots$ {
    public static Roots$ MODULE$;

    static {
        new Roots$();
    }

    public final <A> Vector<Interval<Rational>> isolateRoots(Polynomial<A> poly, RootIsolator<A> isolator) {
        return isolator.isolateRoots(poly);
    }

    public final Polynomial<BigInt> removeFractions(Polynomial<Rational> poly) {
        Rational[] coeffs = (Rational[])poly.coeffsArray(Rational$.MODULE$.RationalAlgebra());
        BigInt factors = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])coeffs)).foldLeft(scala.package$.MODULE$.BigInt().apply(1), (Function2<BigInt, Rational, BigInt> & Serializable & scala.Serializable)(acc, coeff) -> {
            BigInt d = coeff.denominator().toBigInt();
            return acc.$times(d.$div(acc.gcd(d)));
        });
        BigInt[] zCoeffs = (BigInt[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])coeffs)).map((Function1<Rational, BigInt> & Serializable & scala.Serializable)n -> n.numerator().$times(SafeLong$.MODULE$.apply(factors).$div(n.denominator())).toBigInt(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BigInt.class)));
        return Polynomial$.MODULE$.dense(zCoeffs, package$bigInt$.MODULE$.BigIntAlgebra(), package$bigInt$.MODULE$.BigIntAlgebra(), ClassTag$.MODULE$.apply(BigInt.class));
    }

    public final Polynomial<BigInt> removeDecimal(Polynomial<scala.math.BigDecimal> poly) {
        Polynomial<BigInt> polynomial;
        Polynomial<scala.math.BigDecimal> polynomial2 = poly;
        Polynomial<scala.math.BigDecimal> polynomial3 = Polynomial$.MODULE$.zero(package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), ClassTag$.MODULE$.apply(scala.math.BigDecimal.class));
        if (!(polynomial2 != null ? !((Object)polynomial2).equals(polynomial3) : polynomial3 != null)) {
            polynomial = Polynomial$.MODULE$.zero(package$bigInt$.MODULE$.BigIntAlgebra(), package$bigInt$.MODULE$.BigIntAlgebra(), ClassTag$.MODULE$.apply(BigInt.class));
        } else {
            List<?> terms = poly.terms(package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra()).map((Function1<Term, Term> & Serializable & scala.Serializable)x0$1 -> {
                Term term = x0$1;
                if (term == null) {
                    throw new MatchError(term);
                }
                scala.math.BigDecimal c = (scala.math.BigDecimal)term.coeff();
                int e = term.exp();
                Term<BigDecimal> term2 = new Term<BigDecimal>(c.bigDecimal().stripTrailingZeros(), e);
                return term2;
            }, List$.MODULE$.canBuildFrom());
            int maxScale = BoxesRunTime.unboxToInt(((TraversableOnce)terms.map((Function1<Term, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger(Roots$.$anonfun$removeDecimal$2(x$1)), List$.MODULE$.canBuildFrom())).max(Ordering$Int$.MODULE$));
            polynomial = Polynomial$.MODULE$.apply(terms.map((Function1<Term, Term> & Serializable & scala.Serializable)x0$2 -> {
                Term term = x0$2;
                if (term == null) {
                    throw new MatchError(term);
                }
                BigDecimal c = (BigDecimal)term.coeff();
                int e = term.exp();
                BigInt c0 = scala.package$.MODULE$.BigInt().apply(c.movePointRight(maxScale).unscaledValue());
                Term<BigInt> term2 = new Term<BigInt>(c0, e);
                return term2;
            }, List$.MODULE$.canBuildFrom()), package$bigInt$.MODULE$.BigIntAlgebra(), package$bigInt$.MODULE$.BigIntAlgebra(), ClassTag$.MODULE$.apply(BigInt.class));
        }
        return polynomial;
    }

    public final int upperBound(Polynomial<BigInt> p) {
        int lgLastCoeff = p.maxOrderTermCoeff(package$bigInt$.MODULE$.BigIntAlgebra()).abs().bitLength();
        int n = p.degree();
        DoubleRef maxBound = DoubleRef.create(Double.NEGATIVE_INFINITY);
        p.foreachNonZero((Function2<Object, BigInt, Object> & Serializable & scala.Serializable)(k, coeff) -> {
            Roots$.$anonfun$upperBound$1(lgLastCoeff, n, maxBound, BoxesRunTime.unboxToInt(k), coeff);
            return BoxedUnit.UNIT;
        }, package$bigInt$.MODULE$.BigIntAlgebra(), package$bigInt$.MODULE$.BigIntAlgebra());
        if (!RichDouble$.MODULE$.isValidInt$extension(Predef$.MODULE$.doubleWrapper(maxBound.elem))) {
            throw new ArithmeticException("bound too large");
        }
        return (int)maxBound.elem;
    }

    public int lowerBound(Polynomial<BigInt> p) {
        return -this.upperBound(p.reciprocal(package$bigInt$.MODULE$.BigIntAlgebra(), package$bigInt$.MODULE$.BigIntAlgebra()));
    }

    public static final /* synthetic */ int $anonfun$removeDecimal$2(Term x$1) {
        return ((BigDecimal)x$1.coeff()).scale();
    }

    public static final /* synthetic */ void $anonfun$upperBound$1(int lgLastCoeff$1, int n$1, DoubleRef maxBound$1, int k, BigInt coeff) {
        block0: {
            if (k == n$1) break block0;
            int i = n$1 - k;
            int bound = (coeff.abs().bitLength() - lgLastCoeff$1 + 1) / i + 2;
            maxBound$1.elem = package$.MODULE$.max(maxBound$1.elem, (double)bound);
        }
    }

    private Roots$() {
        MODULE$ = this;
    }
}

