/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.hl7;

import com.mulesoft.flatfile.lexical.DelimiterWriter;
import com.mulesoft.flatfile.lexical.WriteException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;

public class HL7Writer
extends DelimiterWriter {
    public HL7Writer(OutputStream os, Charset encoding, String delims, int subst, char segmentTerminator) {
        super(os, encoding, delims.charAt(0), delims.charAt(1), delims.charAt(4), delims.charAt(2), segmentTerminator, null, -1, delims.charAt(3), subst, '.', HL7Writer.charsRestrictions("\r\n"));
    }

    public HL7Writer(OutputStream os, Charset encoding, String delims, int subst) {
        this(os, encoding, delims, subst, '\r');
    }

    private static boolean[] charsRestrictions(String restrictions) {
        int size = 128;
        boolean[] flags = new boolean[size];
        for (int i = 0; i < size; ++i) {
            flags[i] = restrictions.indexOf(i) == -1;
        }
        return flags;
    }

    @Override
    public String convertEscape(char chr) throws WriteException {
        StringBuilder builder = new StringBuilder();
        char rls = (char)this.releaseIndicator;
        builder.append(rls);
        if (chr == this.releaseIndicator) {
            builder.append('E');
        } else if (chr == this.dataSeparator) {
            builder.append('F');
        } else if (chr == this.repetitionSeparator) {
            builder.append('R');
        } else if (chr == this.componentSeparator) {
            builder.append('S');
        } else if (chr == this.subCompSeparator) {
            builder.append('T');
        } else if (chr == '\r') {
            builder.append("X0D");
        } else if (chr == '\n') {
            builder.append("X0A");
        } else {
            throw new WriteException("unsupported character in data " + chr);
        }
        builder.append(rls);
        return builder.toString();
    }

    @Override
    public String convertUnFlagged(char chr, int defaultChar) throws WriteException {
        StringBuilder builder = new StringBuilder();
        char rls = (char)this.releaseIndicator;
        if (chr == '\r') {
            builder.append(rls);
            builder.append("X0D");
            builder.append(rls);
        } else if (chr == '\n') {
            builder.append(rls);
            builder.append("X0A");
            builder.append(rls);
        } else if (defaultChar != -1) {
            builder.append((char)defaultChar);
        } else {
            throw new WriteException("invalid character " + chr + " in data with no release character and/or substitution character defined");
        }
        return builder.toString();
    }

    @Override
    public void init(Map<String, Object> props) throws IOException {
        this.writer.write("MSH");
        this.writeDataSeparator();
        this.writer.write((String)props.get("MSH-02"));
    }

    @Override
    public void term(Map<String, Object> props) throws IOException {
    }

    public void writeSeqId(int value) throws IOException {
        if (value < 0) {
            throw new WriteException("value cannot be negative");
        }
        String text = Integer.toString(value);
        if (text.length() > 4) {
            throw new WriteException("value too long");
        }
        this.writeToken(text);
    }
}

