/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.lib.keyvault.api;

import com.mulesoft.connector.lib.keyvault.api.VaultEncryptionAlgorithm;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class CryptographyResult
implements Serializable {
    private final byte[] data;
    private final String key;
    private VaultEncryptionAlgorithm encryptionAlgorithm;

    public CryptographyResult(byte[] data, String key, VaultEncryptionAlgorithm encryptionAlgorithm) {
        this.data = data;
        this.key = key;
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getKey() {
        return this.key;
    }

    public VaultEncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CryptographyResult that = (CryptographyResult)o;
        return Arrays.equals(this.data, that.data) && Objects.equals(this.key, that.key) && this.encryptionAlgorithm == that.encryptionAlgorithm;
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.key, this.encryptionAlgorithm});
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }
}

