/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.lib.keyvault.crypto;

import com.azure.core.credential.TokenCredential;
import com.azure.core.exception.HttpResponseException;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.security.keyvault.keys.KeyClient;
import com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.azure.security.keyvault.keys.cryptography.CryptographyClientBuilder;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import com.microsoft.aad.msal4j.MsalServiceException;
import com.mulesoft.connector.lib.keyvault.api.TokenCredentialProperties;
import com.mulesoft.connector.lib.keyvault.crypto.CryptoClientProvider;
import com.mulesoft.connector.lib.keyvault.error.AuthenticationException;
import com.mulesoft.connector.lib.keyvault.error.InvalidHostException;
import com.mulesoft.connector.lib.keyvault.error.KeyNotFoundException;
import java.net.UnknownHostException;

public class CryptoClientProviderImpl
implements CryptoClientProvider {
    private TokenCredentialProperties properties;
    private final KeyClient keyClient;

    public CryptoClientProviderImpl(TokenCredentialProperties properties, KeyClient keyClient) {
        this.properties = properties;
        this.keyClient = keyClient;
    }

    @Override
    public CryptographyClient getCryptoClient(String keyName, String version) {
        String keyId = this.getKey(keyName, version).getId();
        ClientSecretCredential credentials = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(this.properties.getClientId())).tenantId(this.properties.getTenantId())).clientSecret(this.properties.getClientSecret()).build();
        return new CryptographyClientBuilder().keyIdentifier(keyId).credential((TokenCredential)credentials).buildClient();
    }

    @Override
    public CryptographyClient getNewCryptoClient(String keyName, String version) {
        return this.getCryptoClient(keyName, null);
    }

    private KeyVaultKey getKey(String name, String version) {
        KeyVaultKey key;
        try {
            key = version == null ? this.keyClient.getKey(name) : this.keyClient.getKey(name, version);
        }
        catch (HttpResponseException e) {
            int errorCode = e.getResponse().getStatusCode();
            if (e.getMessage().contains("VaultNotFound")) {
                throw new InvalidHostException(this.keyClient.getVaultUrl(), e);
            }
            if (errorCode == 400) {
                throw new KeyNotFoundException(name, version, e);
            }
            if (errorCode == 404) {
                throw new KeyNotFoundException(name, e);
            }
            throw e;
        }
        catch (MsalServiceException e) {
            throw new AuthenticationException(e);
        }
        catch (Exception e) {
            if (e.getCause() instanceof UnknownHostException) {
                throw new InvalidHostException(this.keyClient.getVaultUrl(), e);
            }
            throw e;
        }
        return key;
    }
}

