/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.api.model;


import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class DBInstance implements Serializable {


    private static final long serialVersionUID = -7402205314589540291L;
    /**
     * <p>
     * Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.
     * </p>
     */
    private String dbInstanceIdentifier;
    /**
     * <p>
     * Contains the name of the compute and memory capacity class of the DB instance.
     * </p>
     */
    private String dbInstanceClass;
    /**
     * <p>
     * Provides the name of the database engine to be used for this DB instance.
     * </p>
     */
    private String engine;
    /**
     * <p>
     * Specifies the current state of this database.
     * </p>
     */
    private String dbInstanceStatus;
    /**
     * <p>
     * Contains the master username for the DB instance.
     * </p>
     */
    private String masterUsername;
    /**
     * <p>
     * The meaning of this parameter differs according to the database engine you use. For example, this value returns
     * MySQL, MariaDB, or PostgreSQL information when returning values from CreateDBInstanceReadReplica since Read
     * Replicas are only supported for these engines.
     * </p>
     * <p>
     * <b>MySQL, MariaDB, SQL Server, PostgreSQL</b>
     * </p>
     * <p>
     * Contains the name of the initial database of this instance that was provided at create time, if one was specified
     * when the DB instance was created. This same name is returned for the life of the DB instance.
     * </p>
     * <p>
     * Type: String
     * </p>
     * <p>
     * <b>Oracle</b>
     * </p>
     * <p>
     * Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do not
     * apply to an Oracle DB instance.
     * </p>
     */
    private String dbName;

    /**
     * <p>
     * Specifies the connection endpoint.
     * </p>
     */
    private Endpoint endpoint;
    /**
     * <p>
     * Specifies the allocated storage size specified in gigabytes.
     * </p>
     */
    private Integer allocatedStorage;
    /**
     * <p>
     * Provides the date and time the DB instance was created.
     * </p>
     */
    private LocalDateTime instanceCreateTime;
    /**
     * <p>
     * Specifies the daily time range during which automated backups are created if automated backups are enabled, as
     * determined by the <code>BackupRetentionPeriod</code>.
     * </p>
     */
    private String preferredBackupWindow;
    /**
     * <p>
     * Specifies the number of days for which automatic DB snapshots are retained.
     * </p>
     */
    private Integer backupRetentionPeriod;
    /**
     * <p>
     * Provides List of DB security group elements containing only <code>DBSecurityGroup.Name</code> and
     * <code>DBSecurityGroup.Status</code> subelements.
     * </p>
     */
    private List<DBSecurityGroupMembership> dbSecurityGroups;
    /**
     * <p>
     * Provides a list of VPC security group elements that the DB instance belongs to.
     * </p>
     */
    private List<VpcSecurityGroupMembership> vpcSecurityGroups;
    /**
     * <p>
     * Provides the list of DB parameter groups applied to this DB instance.
     * </p>
     */
    private List<DBParameterGroupStatus> dbParameterGroups;
    /**
     * <p>
     * Specifies the name of the Availability Zone the DB instance is located in.
     * </p>
     */
    private String availabilityZone;
    /**
     * <p>
     * Specifies information on the subnet group associated with the DB instance, including the name, description, and
     * subnets in the subnet group.
     * </p>
     */
    private DBSubnetGroup dbSubnetGroup;
    /**
     * <p>
     * Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * </p>
     */
    private String preferredMaintenanceWindow;
    /**
     * <p>
     * Specifies that changes to the DB instance are pending. This element is only included when changes are pending.
     * Specific changes are identified by subelements.
     * </p>
     */
    private PendingModifiedValues pendingModifiedValues;
    /**
     * <p>
     * Specifies the latest time to which a database can be restored with point-in-time restore.
     * </p>
     */
    private LocalDateTime latestRestorableTime;
    /**
     * <p>
     * Specifies if the DB instance is a Multi-AZ deployment.
     * </p>
     */
    private boolean multiAZ;
    /**
     * <p>
     * Indicates the database engine version.
     * </p>
     */
    private String engineVersion;
    /**
     * <p>
     * Indicates that minor version patches are applied automatically.
     * </p>
     */
    private boolean autoMinorVersionUpgrade;
    /**
     * <p>
     * Contains the identifier of the source DB instance if this DB instance is a Read Replica.
     * </p>
     */
    private String readReplicaSourceDBInstanceIdentifier;
    /**
     * <p>
     * Contains one or more identifiers of the Read Replicas associated with this DB instance.
     * </p>
     */
    private List<String> readReplicaDBInstanceIdentifiers;
    /**
     * <p>
     * Contains one or more identifiers of Aurora DB clusters that are Read Replicas of this DB instance.
     * </p>
     */
    private List<String> readReplicaDBClusterIdentifiers;
    /**
     * <p>
     * License model information for this DB instance.
     * </p>
     */
    private String licenseModel;
    /**
     * <p>
     * Specifies the Provisioned IOPS (I/O operations per second) value.
     * </p>
     */
    private Integer iops;
    /**
     * <p>
     * Provides the list of option group memberships for this DB instance.
     * </p>
     */
    private List<OptionGroupMembership> optionGroupMemberships;
    /**
     * <p>
     * If present, specifies the name of the character set that this instance is associated with.
     * </p>
     */
    private String characterSetName;
    /**
     * <p>
     * If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support.
     * </p>
     */
    private String secondaryAvailabilityZone;
    /**
     * <p>
     * Specifies the accessibility options for the DB instance. A value of true specifies an Internet-facing instance
     * with a publicly resolvable DNS name, which resolves to a public IP address. A value of false specifies an
     * internal instance with a DNS name that resolves to a private IP address.
     * </p>
     * <p>
     * Default: The default behavior varies depending on whether a VPC has been requested or not. The following list
     * shows the default behavior in each case.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Default VPC:</b>true
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>VPC:</b>false
     * </p>
     * </li>
     * </ul>
     * <p>
     * If no DB subnet group has been specified as part of the request and the PubliclyAccessible value has not been
     * set, the DB instance will be publicly accessible. If a specific DB subnet group has been specified as part of the
     * request and the PubliclyAccessible value has not been set, the DB instance will be private.
     * </p>
     */
    private boolean publiclyAccessible;
    /**
     * <p>
     * The status of a Read Replica. If the instance is not a Read Replica, this will be blank.
     * </p>
     */
    private List<DBInstanceStatusInfo> statusInfos;
    /**
     * <p>
     * Specifies the storage type associated with DB instance.
     * </p>
     */
    private String storageType;
    /**
     * <p>
     * The ARN from the key store with which the instance is associated for TDE encryption.
     * </p>
     */
    private String tdeCredentialArn;
    /**
     * <p>
     * Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a
     * different port than the DB cluster port.
     * </p>
     */
    private Integer dbInstancePort;
    /**
     * <p>
     * If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a
     * member of.
     * </p>
     */
    private String dbClusterIdentifier;
    /**
     * <p>
     * Specifies whether the DB instance is encrypted.
     * </p>
     */
    private boolean storageEncrypted;
    /**
     * <p>
     * If <code>StorageEncrypted</code> is true, the KMS key identifier for the encrypted DB instance.
     * </p>
     */
    private String kmsKeyId;
    /**
     * <p>
     * The region-unique, immutable identifier for the DB instance. This identifier is found in AWS CloudTrail log
     * entries whenever the KMS key for the DB instance is accessed.
     * </p>
     */
    private String dbiResourceId;
    /**
     * <p>
     * The identifier of the CA certificate for this DB instance.
     * </p>
     */
    private String caCertificateIdentifier;
    /**
     * <p>
     * The Active Directory Domain membership records associated with the DB instance.
     * </p>
     */
    private List<DomainMembership> domainMemberships;
    /**
     * <p>
     * Specifies whether tags are copied from the DB instance to snapshots of the DB instance.
     * </p>
     */
    private boolean copyTagsToSnapshot;
    /**
     * <p>
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.
     * </p>
     */
    private Integer monitoringInterval;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced Monitoring
     * metrics data for the DB instance.
     * </p>
     */
    private String enhancedMonitoringResourceArn;
    /**
     * <p>
     * The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to CloudWatch Logs.
     * </p>
     */
    private String monitoringRoleArn;
    /**
     * <p>
     * A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure
     * of the existing primary instance. For more information, see <a href=
     * "http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html#Aurora.Managing.FaultTolerance">
     * Fault Tolerance for an Aurora DB Cluster</a>.
     * </p>
     */
    private Integer promotionTier;
    /**
     * <p>
     * The Amazon Resource Name (ARN) for the DB instance.
     * </p>
     */
    private String dbInstanceArn;
    /**
     * <p>
     * The time zone of the DB instance. In most cases, the <code>Timezone</code> element is empty.
     * <code>Timezone</code> content appears only for Microsoft SQL Server DB instances that were created with a time
     * zone specified.
     * </p>
     */
    private String timezone;
    /**
     * <p>
     * True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled; otherwise
     * false.
     * </p>
     * <p>
     * IAM database authentication can be enabled for the following database engines
     * </p>
     * <ul>
     * <li>
     * <p>
     * For MySQL 5.6, minor version 5.6.34 or higher
     * </p>
     * </li>
     * <li>
     * <p>
     * For MySQL 5.7, minor version 5.7.16 or higher
     * </p>
     * </li>
     * <li>
     * <p>
     * Aurora 5.6 or higher. To enable IAM database authentication for Aurora, see DBCluster Type.
     * </p>
     * </li>
     * </ul>
     */
    private boolean iamDatabaseAuthenticationEnabled;

    public DBInstance() {
    }


    public String getDbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    public void setDbInstanceIdentifier(String dbInstanceIdentifier) {
        this.dbInstanceIdentifier = dbInstanceIdentifier;
    }


    public String getDbInstanceClass() {
        return dbInstanceClass;
    }

    public void setDbInstanceClass(String dbInstanceClass) {
        this.dbInstanceClass = dbInstanceClass;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public DBInstance withEngine(String engine) {
        this.setEngine(engine);
        return this;
    }


    public String getDbInstanceStatus() {
        return dbInstanceStatus;
    }

    public void setDbInstanceStatus(String dbInstanceStatus) {
        this.dbInstanceStatus = dbInstanceStatus;
    }

    public String getMasterUsername() {
        return this.masterUsername;
    }

    public void setMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
    }

    public String getDbName() {
        return dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Integer getAllocatedStorage() {
        return this.allocatedStorage;
    }

    public void setAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
    }

    public LocalDateTime getInstanceCreateTime() {
        return this.instanceCreateTime;
    }

    public void setInstanceCreateTime(LocalDateTime instanceCreateTime) {
        this.instanceCreateTime = instanceCreateTime;
    }

    public String getPreferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public void setPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
    }

    public DBInstance withPreferredBackupWindow(String preferredBackupWindow) {
        this.setPreferredBackupWindow(preferredBackupWindow);
        return this;
    }

    public Integer getBackupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.backupRetentionPeriod = backupRetentionPeriod;
    }

    public DBInstance withBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.setBackupRetentionPeriod(backupRetentionPeriod);
        return this;
    }


    public List<DBSecurityGroupMembership> getDbSecurityGroups() {
        return dbSecurityGroups;
    }

    public void setDbSecurityGroups(List<DBSecurityGroupMembership> dbSecurityGroups) {
        this.dbSecurityGroups = dbSecurityGroups;
    }

    public List<VpcSecurityGroupMembership> getVpcSecurityGroups() {
        if (this.vpcSecurityGroups == null) {
            this.vpcSecurityGroups = new ArrayList();
        }

        return this.vpcSecurityGroups;
    }

    public void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
        if (vpcSecurityGroups == null) {
            this.vpcSecurityGroups = null;
        } else {
            this.vpcSecurityGroups = new ArrayList(vpcSecurityGroups);
        }
    }

    public DBInstance withVpcSecurityGroups(VpcSecurityGroupMembership... vpcSecurityGroups) {
        if (this.vpcSecurityGroups == null) {
            this.setVpcSecurityGroups(new ArrayList(vpcSecurityGroups.length));
        }

        VpcSecurityGroupMembership[] var2 = vpcSecurityGroups;
        int var3 = vpcSecurityGroups.length;

        for (int var4 = 0; var4 < var3; ++var4) {
            VpcSecurityGroupMembership ele = var2[var4];
            this.vpcSecurityGroups.add(ele);
        }

        return this;
    }


    public List<DBParameterGroupStatus> getDbParameterGroups() {
        return dbParameterGroups;
    }

    public void setDbParameterGroups(List<DBParameterGroupStatus> dbParameterGroups) {
        this.dbParameterGroups = dbParameterGroups;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }


  /*  public void setDBSubnetGroup(DBSubnetGroup dBSubnetGroup) {
        this.dBSubnetGroup = dBSubnetGroup;
    }

    public DBSubnetGroup getDBSubnetGroup() {
        return this.dBSubnetGroup;
    }

    public DBInstance withDBSubnetGroup(DBSubnetGroup dBSubnetGroup) {
        this.setDBSubnetGroup(dBSubnetGroup);
        return this;
    }*/

    public DBSubnetGroup getDbSubnetGroup() {
        return dbSubnetGroup;
    }

    public void setDbSubnetGroup(DBSubnetGroup dbSubnetGroup) {
        this.dbSubnetGroup = dbSubnetGroup;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public PendingModifiedValues getPendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public void setPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
    }

    public LocalDateTime getLatestRestorableTime() {
        return this.latestRestorableTime;
    }

    public void setLatestRestorableTime(LocalDateTime latestRestorableTime) {
        this.latestRestorableTime = latestRestorableTime;
    }

    public boolean getMultiAZ() {
        return this.multiAZ;
    }

    public void setMultiAZ(boolean multiAZ) {
        this.multiAZ = multiAZ;
    }

    public boolean isMultiAZ() {
        return this.multiAZ;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setAutoMinorVersionUpgrade(boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String getReadReplicaSourceDBInstanceIdentifier() {
        return this.readReplicaSourceDBInstanceIdentifier;
    }

    public void setReadReplicaSourceDBInstanceIdentifier(String readReplicaSourceDBInstanceIdentifier) {
        this.readReplicaSourceDBInstanceIdentifier = readReplicaSourceDBInstanceIdentifier;
    }

    public List<String> getReadReplicaDBInstanceIdentifiers() {
        if (this.readReplicaDBInstanceIdentifiers == null) {
            this.readReplicaDBInstanceIdentifiers = new ArrayList();
        }

        return this.readReplicaDBInstanceIdentifiers;
    }

    public void setReadReplicaDBInstanceIdentifiers(Collection<String> readReplicaDBInstanceIdentifiers) {
        if (readReplicaDBInstanceIdentifiers == null) {
            this.readReplicaDBInstanceIdentifiers = null;
        } else {
            this.readReplicaDBInstanceIdentifiers = new ArrayList(readReplicaDBInstanceIdentifiers);
        }
    }

    public DBInstance withReadReplicaDBInstanceIdentifiers(String... readReplicaDBInstanceIdentifiers) {
        if (this.readReplicaDBInstanceIdentifiers == null) {
            this.setReadReplicaDBInstanceIdentifiers(new ArrayList(readReplicaDBInstanceIdentifiers.length));
        }

        String[] var2 = readReplicaDBInstanceIdentifiers;
        int var3 = readReplicaDBInstanceIdentifiers.length;

        for (int var4 = 0; var4 < var3; ++var4) {
            String ele = var2[var4];
            this.readReplicaDBInstanceIdentifiers.add(ele);
        }

        return this;
    }


    public List<String> getReadReplicaDBClusterIdentifiers() {
        if (this.readReplicaDBClusterIdentifiers == null) {
            this.readReplicaDBClusterIdentifiers = new ArrayList();
        }

        return this.readReplicaDBClusterIdentifiers;
    }

    public void setReadReplicaDBClusterIdentifiers(Collection<String> readReplicaDBClusterIdentifiers) {
        if (readReplicaDBClusterIdentifiers == null) {
            this.readReplicaDBClusterIdentifiers = null;
        } else {
            this.readReplicaDBClusterIdentifiers = new ArrayList(readReplicaDBClusterIdentifiers);
        }
    }

    public String getLicenseModel() {
        return this.licenseModel;
    }

    public void setLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
    }

    public Integer getIops() {
        return this.iops;
    }

    public void setIops(Integer iops) {
        this.iops = iops;
    }

    public List<OptionGroupMembership> getOptionGroupMemberships() {
        if (this.optionGroupMemberships == null) {
            this.optionGroupMemberships = new ArrayList();
        }

        return this.optionGroupMemberships;
    }

    public void setOptionGroupMemberships(Collection<OptionGroupMembership> optionGroupMemberships) {
        if (optionGroupMemberships == null) {
            this.optionGroupMemberships = null;
        } else {
            this.optionGroupMemberships = new ArrayList(optionGroupMemberships);
        }
    }

    public String getCharacterSetName() {
        return this.characterSetName;
    }

    public void setCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
    }

    public String getSecondaryAvailabilityZone() {
        return this.secondaryAvailabilityZone;
    }

    public void setSecondaryAvailabilityZone(String secondaryAvailabilityZone) {
        this.secondaryAvailabilityZone = secondaryAvailabilityZone;
    }

    public boolean getPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public void setPubliclyAccessible(boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
    }

    public boolean isPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public List<DBInstanceStatusInfo> getStatusInfos() {
        if (this.statusInfos == null) {
            this.statusInfos = new ArrayList();
        }

        return this.statusInfos;
    }

    public void setStatusInfos(Collection<DBInstanceStatusInfo> statusInfos) {
        if (statusInfos == null) {
            this.statusInfos = null;
        } else {
            this.statusInfos = new ArrayList(statusInfos);
        }
    }

    public String getStorageType() {
        return this.storageType;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public String getTdeCredentialArn() {
        return this.tdeCredentialArn;
    }

    public void setTdeCredentialArn(String tdeCredentialArn) {
        this.tdeCredentialArn = tdeCredentialArn;
    }

    public Integer getDbInstancePort() {
        return this.dbInstancePort;
    }

    public void setDbInstancePort(Integer dbInstancePort) {
        this.dbInstancePort = dbInstancePort;
    }

    public String getDbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    public void setDbClusterIdentifier(String dbClusterIdentifier) {
        this.dbClusterIdentifier = dbClusterIdentifier;
    }

    public boolean getStorageEncrypted() {
        return this.storageEncrypted;
    }

    public void setStorageEncrypted(boolean storageEncrypted) {
        this.storageEncrypted = storageEncrypted;
    }

    public DBInstance withStorageEncrypted(boolean storageEncrypted) {
        this.setStorageEncrypted(storageEncrypted);
        return this;
    }

    public boolean isStorageEncrypted() {
        return this.storageEncrypted;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public DBInstance withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public String getDbiResourceId() {
        return this.dbiResourceId;
    }

    public void setDbiResourceId(String dbiResourceId) {
        this.dbiResourceId = dbiResourceId;
    }

    public DBInstance withDbiResourceId(String dbiResourceId) {
        this.setDbiResourceId(dbiResourceId);
        return this;
    }


    public String getCaCertificateIdentifier() {
        return caCertificateIdentifier;
    }

    public void setCaCertificateIdentifier(String caCertificateIdentifier) {
        this.caCertificateIdentifier = caCertificateIdentifier;
    }

    public List<DomainMembership> getDomainMemberships() {
        if (this.domainMemberships == null) {
            this.domainMemberships = new ArrayList();
        }

        return this.domainMemberships;
    }

    public void setDomainMemberships(Collection<DomainMembership> domainMemberships) {
        if (domainMemberships == null) {
            this.domainMemberships = null;
        } else {
            this.domainMemberships = new ArrayList(domainMemberships);
        }
    }

    public boolean getCopyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public void setCopyTagsToSnapshot(boolean copyTagsToSnapshot) {
        this.copyTagsToSnapshot = copyTagsToSnapshot;
    }

    public boolean isCopyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public Integer getMonitoringInterval() {
        return this.monitoringInterval;
    }

    public void setMonitoringInterval(Integer monitoringInterval) {
        this.monitoringInterval = monitoringInterval;
    }

    public String getEnhancedMonitoringResourceArn() {
        return this.enhancedMonitoringResourceArn;
    }

    public void setEnhancedMonitoringResourceArn(String enhancedMonitoringResourceArn) {
        this.enhancedMonitoringResourceArn = enhancedMonitoringResourceArn;
    }

    public String getMonitoringRoleArn() {
        return this.monitoringRoleArn;
    }

    public void setMonitoringRoleArn(String monitoringRoleArn) {
        this.monitoringRoleArn = monitoringRoleArn;
    }

    public Integer getPromotionTier() {
        return this.promotionTier;
    }

    public void setPromotionTier(Integer promotionTier) {
        this.promotionTier = promotionTier;
    }

    public DBInstance withPromotionTier(Integer promotionTier) {
        this.setPromotionTier(promotionTier);
        return this;
    }


    public String getDbInstanceArn() {
        return dbInstanceArn;
    }

    public void setDbInstanceArn(String dbInstanceArn) {
        this.dbInstanceArn = dbInstanceArn;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public DBInstance withTimezone(String timezone) {
        this.setTimezone(timezone);
        return this;
    }


    public boolean getIamDatabaseAuthenticationEnabled() {
        return iamDatabaseAuthenticationEnabled;
    }

    public void setIamDatabaseAuthenticationEnabled(boolean iamDatabaseAuthenticationEnabled) {
        this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
    }

    @Override
    public String toString() {
        return "DBInstance{" +
                "dbInstanceIdentifier='" + dbInstanceIdentifier + '\'' +
                ", dbInstanceClass='" + dbInstanceClass + '\'' +
                ", engine='" + engine + '\'' +
                ", dbInstanceStatus='" + dbInstanceStatus + '\'' +
                ", masterUsername='" + masterUsername + '\'' +
                ", dbName='" + dbName + '\'' +
                ", endpoint=" + endpoint +
                ", allocatedStorage=" + allocatedStorage +
                ", instanceCreateTime=" + instanceCreateTime +
                ", preferredBackupWindow='" + preferredBackupWindow + '\'' +
                ", backupRetentionPeriod=" + backupRetentionPeriod +
                ", dbSecurityGroups=" + dbSecurityGroups +
                ", vpcSecurityGroups=" + vpcSecurityGroups +
                ", dbParameterGroups=" + dbParameterGroups +
                ", availabilityZone='" + availabilityZone + '\'' +
                ", dbSubnetGroup=" + dbSubnetGroup +
                ", preferredMaintenanceWindow='" + preferredMaintenanceWindow + '\'' +
                ", pendingModifiedValues=" + pendingModifiedValues +
                ", latestRestorableTime=" + latestRestorableTime +
                ", multiAZ=" + multiAZ +
                ", engineVersion='" + engineVersion + '\'' +
                ", autoMinorVersionUpgrade=" + autoMinorVersionUpgrade +
                ", readReplicaSourceDBInstanceIdentifier='" + readReplicaSourceDBInstanceIdentifier + '\'' +
                ", readReplicaDBInstanceIdentifiers=" + readReplicaDBInstanceIdentifiers +
                ", readReplicaDBClusterIdentifiers=" + readReplicaDBClusterIdentifiers +
                ", licenseModel='" + licenseModel + '\'' +
                ", iops=" + iops +
                ", optionGroupMemberships=" + optionGroupMemberships +
                ", characterSetName='" + characterSetName + '\'' +
                ", secondaryAvailabilityZone='" + secondaryAvailabilityZone + '\'' +
                ", publiclyAccessible=" + publiclyAccessible +
                ", statusInfos=" + statusInfos +
                ", storageType='" + storageType + '\'' +
                ", tdeCredentialArn='" + tdeCredentialArn + '\'' +
                ", dbInstancePort=" + dbInstancePort +
                ", dbClusterIdentifier='" + dbClusterIdentifier + '\'' +
                ", storageEncrypted=" + storageEncrypted +
                ", kmsKeyId='" + kmsKeyId + '\'' +
                ", dbiResourceId='" + dbiResourceId + '\'' +
                ", caCertificateIdentifier='" + caCertificateIdentifier + '\'' +
                ", domainMemberships=" + domainMemberships +
                ", copyTagsToSnapshot=" + copyTagsToSnapshot +
                ", monitoringInterval=" + monitoringInterval +
                ", enhancedMonitoringResourceArn='" + enhancedMonitoringResourceArn + '\'' +
                ", monitoringRoleArn='" + monitoringRoleArn + '\'' +
                ", promotionTier=" + promotionTier +
                ", dbInstanceArn='" + dbInstanceArn + '\'' +
                ", timezone='" + timezone + '\'' +
                ", iamDatabaseAuthenticationEnabled=" + iamDatabaseAuthenticationEnabled +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DBInstance that = (DBInstance) o;
        return multiAZ == that.multiAZ &&
                autoMinorVersionUpgrade == that.autoMinorVersionUpgrade &&
                publiclyAccessible == that.publiclyAccessible &&
                storageEncrypted == that.storageEncrypted &&
                copyTagsToSnapshot == that.copyTagsToSnapshot &&
                iamDatabaseAuthenticationEnabled == that.iamDatabaseAuthenticationEnabled &&
                Objects.equals(dbInstanceIdentifier, that.dbInstanceIdentifier) &&
                Objects.equals(dbInstanceClass, that.dbInstanceClass) &&
                Objects.equals(engine, that.engine) &&
                Objects.equals(dbInstanceStatus, that.dbInstanceStatus) &&
                Objects.equals(masterUsername, that.masterUsername) &&
                Objects.equals(dbName, that.dbName) &&
                Objects.equals(endpoint, that.endpoint) &&
                Objects.equals(allocatedStorage, that.allocatedStorage) &&
                Objects.equals(instanceCreateTime, that.instanceCreateTime) &&
                Objects.equals(preferredBackupWindow, that.preferredBackupWindow) &&
                Objects.equals(backupRetentionPeriod, that.backupRetentionPeriod) &&
                Objects.equals(dbSecurityGroups, that.dbSecurityGroups) &&
                Objects.equals(vpcSecurityGroups, that.vpcSecurityGroups) &&
                Objects.equals(dbParameterGroups, that.dbParameterGroups) &&
                Objects.equals(availabilityZone, that.availabilityZone) &&
                Objects.equals(dbSubnetGroup, that.dbSubnetGroup) &&
                Objects.equals(preferredMaintenanceWindow, that.preferredMaintenanceWindow) &&
                Objects.equals(pendingModifiedValues, that.pendingModifiedValues) &&
                Objects.equals(latestRestorableTime, that.latestRestorableTime) &&
                Objects.equals(engineVersion, that.engineVersion) &&
                Objects.equals(readReplicaSourceDBInstanceIdentifier, that.readReplicaSourceDBInstanceIdentifier) &&
                Objects.equals(readReplicaDBInstanceIdentifiers, that.readReplicaDBInstanceIdentifiers) &&
                Objects.equals(readReplicaDBClusterIdentifiers, that.readReplicaDBClusterIdentifiers) &&
                Objects.equals(licenseModel, that.licenseModel) &&
                Objects.equals(iops, that.iops) &&
                Objects.equals(optionGroupMemberships, that.optionGroupMemberships) &&
                Objects.equals(characterSetName, that.characterSetName) &&
                Objects.equals(secondaryAvailabilityZone, that.secondaryAvailabilityZone) &&
                Objects.equals(statusInfos, that.statusInfos) &&
                Objects.equals(storageType, that.storageType) &&
                Objects.equals(tdeCredentialArn, that.tdeCredentialArn) &&
                Objects.equals(dbInstancePort, that.dbInstancePort) &&
                Objects.equals(dbClusterIdentifier, that.dbClusterIdentifier) &&
                Objects.equals(kmsKeyId, that.kmsKeyId) &&
                Objects.equals(dbiResourceId, that.dbiResourceId) &&
                Objects.equals(caCertificateIdentifier, that.caCertificateIdentifier) &&
                Objects.equals(domainMemberships, that.domainMemberships) &&
                Objects.equals(monitoringInterval, that.monitoringInterval) &&
                Objects.equals(enhancedMonitoringResourceArn, that.enhancedMonitoringResourceArn) &&
                Objects.equals(monitoringRoleArn, that.monitoringRoleArn) &&
                Objects.equals(promotionTier, that.promotionTier) &&
                Objects.equals(dbInstanceArn, that.dbInstanceArn) &&
                Objects.equals(timezone, that.timezone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(dbInstanceIdentifier, dbInstanceClass, engine, dbInstanceStatus, masterUsername, dbName, endpoint, allocatedStorage, instanceCreateTime, preferredBackupWindow, backupRetentionPeriod, dbSecurityGroups, vpcSecurityGroups, dbParameterGroups, availabilityZone, dbSubnetGroup, preferredMaintenanceWindow, pendingModifiedValues, latestRestorableTime, multiAZ, engineVersion, autoMinorVersionUpgrade, readReplicaSourceDBInstanceIdentifier, readReplicaDBInstanceIdentifiers, readReplicaDBClusterIdentifiers, licenseModel, iops, optionGroupMemberships, characterSetName, secondaryAvailabilityZone, publiclyAccessible, statusInfos, storageType, tdeCredentialArn, dbInstancePort, dbClusterIdentifier, storageEncrypted, kmsKeyId, dbiResourceId, caCertificateIdentifier, domainMemberships, copyTagsToSnapshot, monitoringInterval, enhancedMonitoringResourceArn, monitoringRoleArn, promotionTier, dbInstanceArn, timezone, iamDatabaseAuthenticationEnabled);
    }
}
