/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.api.model;

import java.io.Serializable;
import java.util.Objects;


public class DBInstanceStatusInfo implements Serializable {

    private static final long serialVersionUID = -8562565665895637571L;

    /**
     * <p>
     * This value is currently "read replication."
     * </p>
     */
    private String statusType;
    /**
     * <p>
     * Boolean value that is true if the instance is operating normally, or false if the instance is in an error state.
     * </p>
     */
    private boolean normal;
    /**
     * <p>
     * Status of the DB instance. For a StatusType of read replica, the values can be replicating, error, stopped, or
     * terminated.
     * </p>
     */
    private String status;
    /**
     * <p>
     * Details of the error if there is an error for the instance. If the instance is not in an error state, this value
     * is blank.
     * </p>
     */
    private String message;

    /**
     * <p>
     * This value is currently "read replication."
     * </p>
     *
     * @return This value is currently "read replication."
     */

    public String getStatusType() {
        return this.statusType;
    }

    /**
     * <p>
     * This value is currently "read replication."
     * </p>
     *
     * @param statusType This value is currently "read replication."
     */

    public void setStatusType(String statusType) {
        this.statusType = statusType;
    }

    /**
     * <p>
     * This value is currently "read replication."
     * </p>
     *
     * @param statusType This value is currently "read replication."
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBInstanceStatusInfo withStatusType(String statusType) {
        setStatusType(statusType);
        return this;
    }

    /**
     * <p>
     * Boolean value that is true if the instance is operating normally, or false if the instance is in an error state.
     * </p>
     *
     * @return Boolean value that is true if the instance is operating normally, or false if the instance is in an error
     * state.
     */

    public boolean getNormal() {
        return this.normal;
    }

    /**
     * <p>
     * Boolean value that is true if the instance is operating normally, or false if the instance is in an error state.
     * </p>
     *
     * @param normal Boolean value that is true if the instance is operating normally, or false if the instance is in an error
     *               state.
     */

    public void setNormal(boolean normal) {
        this.normal = normal;
    }

    /**
     * <p>
     * Boolean value that is true if the instance is operating normally, or false if the instance is in an error state.
     * </p>
     *
     * @param normal Boolean value that is true if the instance is operating normally, or false if the instance is in an error
     *               state.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBInstanceStatusInfo withNormal(Boolean normal) {
        setNormal(normal);
        return this;
    }

    /**
     * <p>
     * Boolean value that is true if the instance is operating normally, or false if the instance is in an error state.
     * </p>
     *
     * @return Boolean value that is true if the instance is operating normally, or false if the instance is in an error
     * state.
     */

    public Boolean isNormal() {
        return this.normal;
    }

    /**
     * <p>
     * Status of the DB instance. For a StatusType of read replica, the values can be replicating, error, stopped, or
     * terminated.
     * </p>
     *
     * @return Status of the DB instance. For a StatusType of read replica, the values can be replicating, error,
     * stopped, or terminated.
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * Status of the DB instance. For a StatusType of read replica, the values can be replicating, error, stopped, or
     * terminated.
     * </p>
     *
     * @param status Status of the DB instance. For a StatusType of read replica, the values can be replicating, error,
     *               stopped, or terminated.
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * Status of the DB instance. For a StatusType of read replica, the values can be replicating, error, stopped, or
     * terminated.
     * </p>
     *
     * @param status Status of the DB instance. For a StatusType of read replica, the values can be replicating, error,
     *               stopped, or terminated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBInstanceStatusInfo withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * Details of the error if there is an error for the instance. If the instance is not in an error state, this value
     * is blank.
     * </p>
     *
     * @return Details of the error if there is an error for the instance. If the instance is not in an error state,
     * this value is blank.
     */

    public String getMessage() {
        return this.message;
    }

    /**
     * <p>
     * Details of the error if there is an error for the instance. If the instance is not in an error state, this value
     * is blank.
     * </p>
     *
     * @param message Details of the error if there is an error for the instance. If the instance is not in an error state, this
     *                value is blank.
     */

    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * <p>
     * Details of the error if there is an error for the instance. If the instance is not in an error state, this value
     * is blank.
     * </p>
     *
     * @param message Details of the error if there is an error for the instance. If the instance is not in an error state, this
     *                value is blank.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBInstanceStatusInfo withMessage(String message) {
        setMessage(message);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and debugging.
     *
     * @return A string representation of this object.
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "DBInstanceStatusInfo{" +
                "statusType='" + statusType + '\'' +
                ", normal=" + normal +
                ", status='" + status + '\'' +
                ", message='" + message + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DBInstanceStatusInfo that = (DBInstanceStatusInfo) o;
        return normal == that.normal &&
                Objects.equals(statusType, that.statusType) &&
                Objects.equals(status, that.status) &&
                Objects.equals(message, that.message);
    }

    @Override
    public int hashCode() {
        return Objects.hash(statusType, normal, status, message);
    }
}
