/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.api.model;

import java.io.Serializable;

public class DBParameterGroupStatus implements Serializable {

    private static final long serialVersionUID = -3682119467706151153L;

    /**
     * <p>
     * The name of the DP parameter group.
     * </p>
     */
    private String dBParameterGroupName;
    /**
     * <p>
     * The status of parameter updates.
     * </p>
     */
    private String parameterApplyStatus;

    public DBParameterGroupStatus() {
    }

    /**
     * <p>
     * The name of the DP parameter group.
     * </p>
     *
     * @return The name of the DP parameter group.
     */

    public String getDBParameterGroupName() {
        return this.dBParameterGroupName;
    }

    /**
     * <p>
     * The name of the DP parameter group.
     * </p>
     *
     * @param dBParameterGroupName The name of the DP parameter group.
     */

    public void setDBParameterGroupName(String dBParameterGroupName) {
        this.dBParameterGroupName = dBParameterGroupName;
    }

    /**
     * <p>
     * The status of parameter updates.
     * </p>
     *
     * @return The status of parameter updates.
     */
    public String getParameterApplyStatus() {
        return this.parameterApplyStatus;
    }

    /**
     * <p>
     * The status of parameter updates.
     * </p>
     *
     * @param parameterApplyStatus The status of parameter updates.
     */

    public void setParameterApplyStatus(String parameterApplyStatus) {
        this.parameterApplyStatus = parameterApplyStatus;
    }

    /**
     * Returns a string representation of this object; useful for testing and debugging.
     *
     * @return A string representation of this object.
     * @see java.lang.Object#toString()
     */

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDBParameterGroupName() != null) {
            sb.append("DBParameterGroupName: ").append(this.getDBParameterGroupName()).append(",");
        }

        if (this.getParameterApplyStatus() != null) {
            sb.append("ParameterApplyStatus: ").append(this.getParameterApplyStatus());
        }

        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        } else if (obj == null) {
            return false;
        } else if (!(obj instanceof DBParameterGroupStatus)) {
            return false;
        } else {
            DBParameterGroupStatus other = (DBParameterGroupStatus) obj;
            return other.getDBParameterGroupName() == null ^ this.getDBParameterGroupName() == null ? false : (other.getDBParameterGroupName() != null && !other.getDBParameterGroupName().equals(this.getDBParameterGroupName()) ? false : (other.getParameterApplyStatus() == null ^ this.getParameterApplyStatus() == null ? false : other.getParameterApplyStatus() == null || other.getParameterApplyStatus().equals(this.getParameterApplyStatus())));
        }
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = prime * hashCode + (this.getDBParameterGroupName() == null ? 0 : this.getDBParameterGroupName().hashCode());
        hashCode = prime * hashCode + (this.getParameterApplyStatus() == null ? 0 : this.getParameterApplyStatus().hashCode());
        return hashCode;
    }
}
