/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.api.model;

import java.io.Serializable;

public class DBSecurityGroupMembership implements Serializable {


    private static final long serialVersionUID = -4488501091157037284L;

    /**
     * <p>
     * The name of the DB security group.
     * </p>
     */
    private String dBSecurityGroupName;
    /**
     * <p>
     * The status of the DB security group.
     * </p>
     */
    private String status;

    public DBSecurityGroupMembership() {
    }

    /**
     * <p>
     * The name of the DB security group.
     * </p>
     *
     * @return The name of the DB security group.
     */
    public String getDBSecurityGroupName() {
        return this.dBSecurityGroupName;
    }

    /**
     * <p>
     * The name of the DB security group.
     * </p>
     *
     * @param dBSecurityGroupName The name of the DB security group.
     */
    public void setDBSecurityGroupName(String dBSecurityGroupName) {
        this.dBSecurityGroupName = dBSecurityGroupName;
    }

    /**
     * <p>
     * The status of the DB security group.
     * </p>
     *
     * @return The status of the DB security group.
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The status of the DB security group.
     * </p>
     *
     * @param status The status of the DB security group.
     */

    public void setStatus(String status) {
        this.status = status;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDBSecurityGroupName() != null) {
            sb.append("DBSecurityGroupName: ").append(this.getDBSecurityGroupName()).append(",");
        }

        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus());
        }

        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        } else if (obj == null) {
            return false;
        } else if (!(obj instanceof DBSecurityGroupMembership)) {
            return false;
        } else {
            DBSecurityGroupMembership other = (DBSecurityGroupMembership) obj;
            return other.getDBSecurityGroupName() == null ^ this.getDBSecurityGroupName() == null ? false : (other.getDBSecurityGroupName() != null && !other.getDBSecurityGroupName().equals(this.getDBSecurityGroupName()) ? false : (other.getStatus() == null ^ this.getStatus() == null ? false : other.getStatus() == null || other.getStatus().equals(this.getStatus())));
        }
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = prime * hashCode + (this.getDBSecurityGroupName() == null ? 0 : this.getDBSecurityGroupName().hashCode());
        hashCode = prime * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        return hashCode;
    }
}
