/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.api.model;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;

public class DBSnapshot implements Serializable {

    /**
     * <p>
     * Specifies the identifier for the DB snapshot.
     * </p>
     */
    private String dbSnapshotIdentifier;
    /**
     * <p>
     * Specifies the DB instance identifier of the DB instance this DB snapshot was created from.
     * </p>
     */
    private String dbInstanceIdentifier;
    /**
     * <p>
     * Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).
     * </p>
     */
    private LocalDateTime snapshotCreateTime;
    /**
     * <p>
     * Specifies the name of the database engine.
     * </p>
     */
    private String engine;
    /**
     * <p>
     * Specifies the allocated storage size in gigabytes (GB).
     * </p>
     */
    private Integer allocatedStorage;
    /**
     * <p>
     * Specifies the status of this DB snapshot.
     * </p>
     */
    private String status;
    /**
     * <p>
     * Specifies the port that the database engine was listening on at the time of the snapshot.
     * </p>
     */
    private Integer port;
    /**
     * <p>
     * Specifies the name of the Availability Zone the DB instance was located in at the time of the DB snapshot.
     * </p>
     */
    private String availabilityZone;
    /**
     * <p>
     * Provides the VPC ID associated with the DB snapshot.
     * </p>
     */
    private String vpcId;
    /**
     * <p>
     * Specifies the time when the snapshot was taken, in Universal Coordinated Time (UTC).
     * </p>
     */
    private LocalDateTime instanceCreateTime;
    /**
     * <p>
     * Provides the master username for the DB snapshot.
     * </p>
     */
    private String masterUsername;
    /**
     * <p>
     * Specifies the version of the database engine.
     * </p>
     */
    private String engineVersion;
    /**
     * <p>
     * License model information for the restored DB instance.
     * </p>
     */
    private String licenseModel;
    /**
     * <p>
     * Provides the type of the DB snapshot.
     * </p>
     */
    private String snapshotType;
    /**
     * <p>
     * Specifies the Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.
     * </p>
     */
    private Integer iops;
    /**
     * <p>
     * Provides the option group name for the DB snapshot.
     * </p>
     */
    private String optionGroupName;
    /**
     * <p>
     * The percentage of the estimated data that has been transferred.
     * </p>
     */
    private Integer percentProgress;
    /**
     * <p>
     * The region that the DB snapshot was created in or copied from.
     * </p>
     */
    private String sourceRegion;
    /**
     * <p>
     * The DB snapshot Arn that the DB snapshot was copied from. It only has value in case of cross customer or cross
     * region copy.
     * </p>
     */
    private String sourceDBSnapshotIdentifier;
    /**
     * <p>
     * Specifies the storage type associated with DB snapshot.
     * </p>
     */
    private String storageType;
    /**
     * <p>
     * The ARN from the key store with which to associate the instance for TDE encryption.
     * </p>
     */
    private String tdeCredentialArn;
    /**
     * <p>
     * Specifies whether the DB snapshot is encrypted.
     * </p>
     */
    private boolean encrypted;
    /**
     * <p>
     * If <code>Encrypted</code> is true, the KMS key identifier for the encrypted DB snapshot.
     * </p>
     */
    private String kmsKeyId;
    /**
     * <p>
     * The Amazon Resource Name (ARN) for the DB snapshot.
     * </p>
     */
    private String dbSnapshotArn;
    /**
     * <p>
     * The time zone of the DB snapshot. In most cases, the <code>Timezone</code> element is empty.
     * <code>Timezone</code> content appears only for snapshots taken from Microsoft SQL Server DB instances that were
     * created with a time zone specified.
     * </p>
     */
    private String timezone;
    /**
     * <p>
     * True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled; otherwise
     * false.
     * </p>
     */
    private boolean iamDatabaseAuthenticationEnabled;

    /**
     * <p>
     * Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).
     * </p>
     *
     * @return Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).
     */

    public LocalDateTime getSnapshotCreateTime() {
        return this.snapshotCreateTime;
    }

    /**
     * <p>
     * Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).
     * </p>
     *
     * @param snapshotCreateTime Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).
     */
    public void setSnapshotCreateTime(LocalDateTime snapshotCreateTime) {
        this.snapshotCreateTime = snapshotCreateTime;
    }

    /**
     * <p>
     * Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).
     * </p>
     *
     * @param snapshotCreateTime Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withSnapshotCreateTime(LocalDateTime snapshotCreateTime) {
        setSnapshotCreateTime(snapshotCreateTime);
        return this;
    }

    /**
     * <p>
     * Specifies the name of the database engine.
     * </p>
     *
     * @return Specifies the name of the database engine.
     */

    public String getEngine() {
        return this.engine;
    }

    /**
     * <p>
     * Specifies the name of the database engine.
     * </p>
     *
     * @param engine Specifies the name of the database engine.
     */

    public void setEngine(String engine) {
        this.engine = engine;
    }

    /**
     * <p>
     * Specifies the name of the database engine.
     * </p>
     *
     * @param engine Specifies the name of the database engine.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withEngine(String engine) {
        setEngine(engine);
        return this;
    }

    /**
     * <p>
     * Specifies the allocated storage size in gigabytes (GB).
     * </p>
     *
     * @return Specifies the allocated storage size in gigabytes (GB).
     */

    public Integer getAllocatedStorage() {
        return this.allocatedStorage;
    }

    /**
     * <p>
     * Specifies the allocated storage size in gigabytes (GB).
     * </p>
     *
     * @param allocatedStorage Specifies the allocated storage size in gigabytes (GB).
     */

    public void setAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
    }

    /**
     * <p>
     * Specifies the allocated storage size in gigabytes (GB).
     * </p>
     *
     * @param allocatedStorage Specifies the allocated storage size in gigabytes (GB).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withAllocatedStorage(Integer allocatedStorage) {
        setAllocatedStorage(allocatedStorage);
        return this;
    }

    /**
     * <p>
     * Specifies the status of this DB snapshot.
     * </p>
     *
     * @return Specifies the status of this DB snapshot.
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * Specifies the status of this DB snapshot.
     * </p>
     *
     * @param status Specifies the status of this DB snapshot.
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * Specifies the status of this DB snapshot.
     * </p>
     *
     * @param status Specifies the status of this DB snapshot.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * Specifies the port that the database engine was listening on at the time of the snapshot.
     * </p>
     *
     * @return Specifies the port that the database engine was listening on at the time of the snapshot.
     */

    public Integer getPort() {
        return this.port;
    }

    /**
     * <p>
     * Specifies the port that the database engine was listening on at the time of the snapshot.
     * </p>
     *
     * @param port Specifies the port that the database engine was listening on at the time of the snapshot.
     */

    public void setPort(Integer port) {
        this.port = port;
    }

    /**
     * <p>
     * Specifies the port that the database engine was listening on at the time of the snapshot.
     * </p>
     *
     * @param port Specifies the port that the database engine was listening on at the time of the snapshot.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withPort(Integer port) {
        setPort(port);
        return this;
    }

    /**
     * <p>
     * Specifies the name of the Availability Zone the DB instance was located in at the time of the DB snapshot.
     * </p>
     *
     * @return Specifies the name of the Availability Zone the DB instance was located in at the time of the DB
     * snapshot.
     */

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    /**
     * <p>
     * Specifies the name of the Availability Zone the DB instance was located in at the time of the DB snapshot.
     * </p>
     *
     * @param availabilityZone Specifies the name of the Availability Zone the DB instance was located in at the time of the DB snapshot.
     */

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    /**
     * <p>
     * Specifies the name of the Availability Zone the DB instance was located in at the time of the DB snapshot.
     * </p>
     *
     * @param availabilityZone Specifies the name of the Availability Zone the DB instance was located in at the time of the DB snapshot.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withAvailabilityZone(String availabilityZone) {
        setAvailabilityZone(availabilityZone);
        return this;
    }

    /**
     * <p>
     * Provides the VPC ID associated with the DB snapshot.
     * </p>
     *
     * @return Provides the VPC ID associated with the DB snapshot.
     */

    public String getVpcId() {
        return this.vpcId;
    }

    /**
     * <p>
     * Provides the VPC ID associated with the DB snapshot.
     * </p>
     *
     * @param vpcId Provides the VPC ID associated with the DB snapshot.
     */

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    /**
     * <p>
     * Provides the VPC ID associated with the DB snapshot.
     * </p>
     *
     * @param vpcId Provides the VPC ID associated with the DB snapshot.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withVpcId(String vpcId) {
        setVpcId(vpcId);
        return this;
    }

    /**
     * <p>
     * Specifies the time when the snapshot was taken, in Universal Coordinated Time (UTC).
     * </p>
     *
     * @return Specifies the time when the snapshot was taken, in Universal Coordinated Time (UTC).
     */
    public LocalDateTime getInstanceCreateTime() {
        return this.instanceCreateTime;
    }

    /**
     * <p>
     * Specifies the time when the snapshot was taken, in Universal Coordinated Time (UTC).
     * </p>
     *
     * @param instanceCreateTime Specifies the time when the snapshot was taken, in Universal Coordinated Time (UTC).
     */
    public void setInstanceCreateTime(LocalDateTime instanceCreateTime) {
        this.instanceCreateTime = instanceCreateTime;
    }

    /**
     * <p>
     * Specifies the time when the snapshot was taken, in Universal Coordinated Time (UTC).
     * </p>
     *
     * @param instanceCreateTime Specifies the time when the snapshot was taken, in Universal Coordinated Time (UTC).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withInstanceCreateTime(LocalDateTime instanceCreateTime) {
        setInstanceCreateTime(instanceCreateTime);
        return this;
    }

    /**
     * <p>
     * Provides the master username for the DB snapshot.
     * </p>
     *
     * @return Provides the master username for the DB snapshot.
     */

    public String getMasterUsername() {
        return this.masterUsername;
    }

    /**
     * <p>
     * Provides the master username for the DB snapshot.
     * </p>
     *
     * @param masterUsername Provides the master username for the DB snapshot.
     */

    public void setMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
    }

    /**
     * <p>
     * Provides the master username for the DB snapshot.
     * </p>
     *
     * @param masterUsername Provides the master username for the DB snapshot.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withMasterUsername(String masterUsername) {
        setMasterUsername(masterUsername);
        return this;
    }

    /**
     * <p>
     * Specifies the version of the database engine.
     * </p>
     *
     * @return Specifies the version of the database engine.
     */

    public String getEngineVersion() {
        return this.engineVersion;
    }

    /**
     * <p>
     * Specifies the version of the database engine.
     * </p>
     *
     * @param engineVersion Specifies the version of the database engine.
     */

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    /**
     * <p>
     * Specifies the version of the database engine.
     * </p>
     *
     * @param engineVersion Specifies the version of the database engine.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withEngineVersion(String engineVersion) {
        setEngineVersion(engineVersion);
        return this;
    }

    /**
     * <p>
     * License model information for the restored DB instance.
     * </p>
     *
     * @return License model information for the restored DB instance.
     */

    public String getLicenseModel() {
        return this.licenseModel;
    }

    /**
     * <p>
     * License model information for the restored DB instance.
     * </p>
     *
     * @param licenseModel License model information for the restored DB instance.
     */

    public void setLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
    }

    /**
     * <p>
     * License model information for the restored DB instance.
     * </p>
     *
     * @param licenseModel License model information for the restored DB instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withLicenseModel(String licenseModel) {
        setLicenseModel(licenseModel);
        return this;
    }

    /**
     * <p>
     * Provides the type of the DB snapshot.
     * </p>
     *
     * @return Provides the type of the DB snapshot.
     */

    public String getSnapshotType() {
        return this.snapshotType;
    }

    /**
     * <p>
     * Provides the type of the DB snapshot.
     * </p>
     *
     * @param snapshotType Provides the type of the DB snapshot.
     */

    public void setSnapshotType(String snapshotType) {
        this.snapshotType = snapshotType;
    }

    /**
     * <p>
     * Provides the type of the DB snapshot.
     * </p>
     *
     * @param snapshotType Provides the type of the DB snapshot.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withSnapshotType(String snapshotType) {
        setSnapshotType(snapshotType);
        return this;
    }

    /**
     * <p>
     * Specifies the Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.
     * </p>
     *
     * @return Specifies the Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the
     * snapshot.
     */

    public Integer getIops() {
        return this.iops;
    }

    /**
     * <p>
     * Specifies the Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.
     * </p>
     *
     * @param iops Specifies the Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the
     *             snapshot.
     */

    public void setIops(Integer iops) {
        this.iops = iops;
    }

    /**
     * <p>
     * Specifies the Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.
     * </p>
     *
     * @param iops Specifies the Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the
     *             snapshot.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withIops(Integer iops) {
        setIops(iops);
        return this;
    }

    /**
     * <p>
     * Provides the option group name for the DB snapshot.
     * </p>
     *
     * @return Provides the option group name for the DB snapshot.
     */

    public String getOptionGroupName() {
        return this.optionGroupName;
    }

    /**
     * <p>
     * Provides the option group name for the DB snapshot.
     * </p>
     *
     * @param optionGroupName Provides the option group name for the DB snapshot.
     */

    public void setOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
    }

    /**
     * <p>
     * Provides the option group name for the DB snapshot.
     * </p>
     *
     * @param optionGroupName Provides the option group name for the DB snapshot.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withOptionGroupName(String optionGroupName) {
        setOptionGroupName(optionGroupName);
        return this;
    }

    /**
     * <p>
     * The percentage of the estimated data that has been transferred.
     * </p>
     *
     * @return The percentage of the estimated data that has been transferred.
     */

    public Integer getPercentProgress() {
        return this.percentProgress;
    }

    /**
     * <p>
     * The percentage of the estimated data that has been transferred.
     * </p>
     *
     * @param percentProgress The percentage of the estimated data that has been transferred.
     */

    public void setPercentProgress(Integer percentProgress) {
        this.percentProgress = percentProgress;
    }

    /**
     * <p>
     * The percentage of the estimated data that has been transferred.
     * </p>
     *
     * @param percentProgress The percentage of the estimated data that has been transferred.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withPercentProgress(Integer percentProgress) {
        setPercentProgress(percentProgress);
        return this;
    }

    /**
     * <p>
     * The region that the DB snapshot was created in or copied from.
     * </p>
     *
     * @return The region that the DB snapshot was created in or copied from.
     */

    public String getSourceRegion() {
        return this.sourceRegion;
    }

    /**
     * <p>
     * The region that the DB snapshot was created in or copied from.
     * </p>
     *
     * @param sourceRegion The region that the DB snapshot was created in or copied from.
     */

    public void setSourceRegion(String sourceRegion) {
        this.sourceRegion = sourceRegion;
    }

    /**
     * <p>
     * The region that the DB snapshot was created in or copied from.
     * </p>
     *
     * @param sourceRegion The region that the DB snapshot was created in or copied from.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withSourceRegion(String sourceRegion) {
        setSourceRegion(sourceRegion);
        return this;
    }

    /**
     * <p>
     * The DB snapshot Arn that the DB snapshot was copied from. It only has value in case of cross customer or cross
     * region copy.
     * </p>
     *
     * @return The DB snapshot Arn that the DB snapshot was copied from. It only has value in case of cross customer or
     * cross region copy.
     */

    public String getSourceDBSnapshotIdentifier() {
        return this.sourceDBSnapshotIdentifier;
    }

    /**
     * <p>
     * The DB snapshot Arn that the DB snapshot was copied from. It only has value in case of cross customer or cross
     * region copy.
     * </p>
     *
     * @param sourceDBSnapshotIdentifier The DB snapshot Arn that the DB snapshot was copied from. It only has value in case of cross customer or
     *                                   cross region copy.
     */

    public void setSourceDBSnapshotIdentifier(String sourceDBSnapshotIdentifier) {
        this.sourceDBSnapshotIdentifier = sourceDBSnapshotIdentifier;
    }

    /**
     * <p>
     * The DB snapshot Arn that the DB snapshot was copied from. It only has value in case of cross customer or cross
     * region copy.
     * </p>
     *
     * @param sourceDBSnapshotIdentifier The DB snapshot Arn that the DB snapshot was copied from. It only has value in case of cross customer or
     *                                   cross region copy.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withSourceDBSnapshotIdentifier(String sourceDBSnapshotIdentifier) {
        setSourceDBSnapshotIdentifier(sourceDBSnapshotIdentifier);
        return this;
    }

    /**
     * <p>
     * Specifies the storage type associated with DB snapshot.
     * </p>
     *
     * @return Specifies the storage type associated with DB snapshot.
     */

    public String getStorageType() {
        return this.storageType;
    }

    /**
     * <p>
     * Specifies the storage type associated with DB snapshot.
     * </p>
     *
     * @param storageType Specifies the storage type associated with DB snapshot.
     */

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    /**
     * <p>
     * Specifies the storage type associated with DB snapshot.
     * </p>
     *
     * @param storageType Specifies the storage type associated with DB snapshot.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withStorageType(String storageType) {
        setStorageType(storageType);
        return this;
    }

    /**
     * <p>
     * The ARN from the key store with which to associate the instance for TDE encryption.
     * </p>
     *
     * @return The ARN from the key store with which to associate the instance for TDE encryption.
     */

    public String getTdeCredentialArn() {
        return this.tdeCredentialArn;
    }

    /**
     * <p>
     * The ARN from the key store with which to associate the instance for TDE encryption.
     * </p>
     *
     * @param tdeCredentialArn The ARN from the key store with which to associate the instance for TDE encryption.
     */

    public void setTdeCredentialArn(String tdeCredentialArn) {
        this.tdeCredentialArn = tdeCredentialArn;
    }

    /**
     * <p>
     * The ARN from the key store with which to associate the instance for TDE encryption.
     * </p>
     *
     * @param tdeCredentialArn The ARN from the key store with which to associate the instance for TDE encryption.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withTdeCredentialArn(String tdeCredentialArn) {
        setTdeCredentialArn(tdeCredentialArn);
        return this;
    }

    /**
     * <p>
     * Specifies whether the DB snapshot is encrypted.
     * </p>
     *
     * @return Specifies whether the DB snapshot is encrypted.
     */

    public boolean getEncrypted() {
        return this.encrypted;
    }

    /**
     * <p>
     * Specifies whether the DB snapshot is encrypted.
     * </p>
     *
     * @param encrypted Specifies whether the DB snapshot is encrypted.
     */

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    /**
     * <p>
     * Specifies whether the DB snapshot is encrypted.
     * </p>
     *
     * @param encrypted Specifies whether the DB snapshot is encrypted.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withEncrypted(boolean encrypted) {
        setEncrypted(encrypted);
        return this;
    }

    /**
     * <p>
     * Specifies whether the DB snapshot is encrypted.
     * </p>
     *
     * @return Specifies whether the DB snapshot is encrypted.
     */

    public boolean isEncrypted() {
        return this.encrypted;
    }

    /**
     * <p>
     * If <code>Encrypted</code> is true, the KMS key identifier for the encrypted DB snapshot.
     * </p>
     *
     * @return If <code>Encrypted</code> is true, the KMS key identifier for the encrypted DB snapshot.
     */

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    /**
     * <p>
     * If <code>Encrypted</code> is true, the KMS key identifier for the encrypted DB snapshot.
     * </p>
     *
     * @param kmsKeyId If <code>Encrypted</code> is true, the KMS key identifier for the encrypted DB snapshot.
     */

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    /**
     * <p>
     * If <code>Encrypted</code> is true, the KMS key identifier for the encrypted DB snapshot.
     * </p>
     *
     * @param kmsKeyId If <code>Encrypted</code> is true, the KMS key identifier for the encrypted DB snapshot.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withKmsKeyId(String kmsKeyId) {
        setKmsKeyId(kmsKeyId);
        return this;
    }

    /**
     * <p>
     * The time zone of the DB snapshot. In most cases, the <code>Timezone</code> element is empty.
     * <code>Timezone</code> content appears only for snapshots taken from Microsoft SQL Server DB instances that were
     * created with a time zone specified.
     * </p>
     *
     * @return The time zone of the DB snapshot. In most cases, the <code>Timezone</code> element is empty.
     * <code>Timezone</code> content appears only for snapshots taken from Microsoft SQL Server DB instances
     * that were created with a time zone specified.
     */

    public String getTimezone() {
        return this.timezone;
    }

    /**
     * <p>
     * The time zone of the DB snapshot. In most cases, the <code>Timezone</code> element is empty.
     * <code>Timezone</code> content appears only for snapshots taken from Microsoft SQL Server DB instances that were
     * created with a time zone specified.
     * </p>
     *
     * @param timezone The time zone of the DB snapshot. In most cases, the <code>Timezone</code> element is empty.
     *                 <code>Timezone</code> content appears only for snapshots taken from Microsoft SQL Server DB instances that
     *                 were created with a time zone specified.
     */

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    /**
     * <p>
     * The time zone of the DB snapshot. In most cases, the <code>Timezone</code> element is empty.
     * <code>Timezone</code> content appears only for snapshots taken from Microsoft SQL Server DB instances that were
     * created with a time zone specified.
     * </p>
     *
     * @param timezone The time zone of the DB snapshot. In most cases, the <code>Timezone</code> element is empty.
     *                 <code>Timezone</code> content appears only for snapshots taken from Microsoft SQL Server DB instances that
     *                 were created with a time zone specified.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DBSnapshot withTimezone(String timezone) {
        setTimezone(timezone);
        return this;
    }

    public String getDbSnapshotIdentifier() {
        return dbSnapshotIdentifier;
    }

    public void setDbSnapshotIdentifier(String dbSnapshotIdentifier) {
        this.dbSnapshotIdentifier = dbSnapshotIdentifier;
    }

    public String getDbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    public void setDbInstanceIdentifier(String dbInstanceIdentifier) {
        this.dbInstanceIdentifier = dbInstanceIdentifier;
    }

    public String getDbSnapshotArn() {
        return dbSnapshotArn;
    }

    public void setDbSnapshotArn(String dbSnapshotArn) {
        this.dbSnapshotArn = dbSnapshotArn;
    }

    public boolean getIamDatabaseAuthenticationEnabled() {
        return iamDatabaseAuthenticationEnabled;
    }

    public void setIamDatabaseAuthenticationEnabled(boolean iamDatabaseAuthenticationEnabled) {
        this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DBSnapshot that = (DBSnapshot) o;
        return encrypted == that.encrypted &&
                iamDatabaseAuthenticationEnabled == that.iamDatabaseAuthenticationEnabled &&
                Objects.equals(dbSnapshotIdentifier, that.dbSnapshotIdentifier) &&
                Objects.equals(dbInstanceIdentifier, that.dbInstanceIdentifier) &&
                Objects.equals(snapshotCreateTime, that.snapshotCreateTime) &&
                Objects.equals(engine, that.engine) &&
                Objects.equals(allocatedStorage, that.allocatedStorage) &&
                Objects.equals(status, that.status) &&
                Objects.equals(port, that.port) &&
                Objects.equals(availabilityZone, that.availabilityZone) &&
                Objects.equals(vpcId, that.vpcId) &&
                Objects.equals(instanceCreateTime, that.instanceCreateTime) &&
                Objects.equals(masterUsername, that.masterUsername) &&
                Objects.equals(engineVersion, that.engineVersion) &&
                Objects.equals(licenseModel, that.licenseModel) &&
                Objects.equals(snapshotType, that.snapshotType) &&
                Objects.equals(iops, that.iops) &&
                Objects.equals(optionGroupName, that.optionGroupName) &&
                Objects.equals(percentProgress, that.percentProgress) &&
                Objects.equals(sourceRegion, that.sourceRegion) &&
                Objects.equals(sourceDBSnapshotIdentifier, that.sourceDBSnapshotIdentifier) &&
                Objects.equals(storageType, that.storageType) &&
                Objects.equals(tdeCredentialArn, that.tdeCredentialArn) &&
                Objects.equals(kmsKeyId, that.kmsKeyId) &&
                Objects.equals(dbSnapshotArn, that.dbSnapshotArn) &&
                Objects.equals(timezone, that.timezone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(dbSnapshotIdentifier, dbInstanceIdentifier, snapshotCreateTime, engine, allocatedStorage, status, port, availabilityZone, vpcId, instanceCreateTime, masterUsername, engineVersion, licenseModel, snapshotType, iops, optionGroupName, percentProgress, sourceRegion, sourceDBSnapshotIdentifier, storageType, tdeCredentialArn, encrypted, kmsKeyId, dbSnapshotArn, timezone, iamDatabaseAuthenticationEnabled);
    }

    @Override
    public String toString() {
        return "DBSnapshot{" +
                "dbSnapshotIdentifier='" + dbSnapshotIdentifier + '\'' +
                ", dbInstanceIdentifier='" + dbInstanceIdentifier + '\'' +
                ", snapshotCreateTime=" + snapshotCreateTime +
                ", engine='" + engine + '\'' +
                ", allocatedStorage=" + allocatedStorage +
                ", status='" + status + '\'' +
                ", port=" + port +
                ", availabilityZone='" + availabilityZone + '\'' +
                ", vpcId='" + vpcId + '\'' +
                ", instanceCreateTime=" + instanceCreateTime +
                ", masterUsername='" + masterUsername + '\'' +
                ", engineVersion='" + engineVersion + '\'' +
                ", licenseModel='" + licenseModel + '\'' +
                ", snapshotType='" + snapshotType + '\'' +
                ", iops=" + iops +
                ", optionGroupName='" + optionGroupName + '\'' +
                ", percentProgress=" + percentProgress +
                ", sourceRegion='" + sourceRegion + '\'' +
                ", sourceDBSnapshotIdentifier='" + sourceDBSnapshotIdentifier + '\'' +
                ", storageType='" + storageType + '\'' +
                ", tdeCredentialArn='" + tdeCredentialArn + '\'' +
                ", encrypted=" + encrypted +
                ", kmsKeyId='" + kmsKeyId + '\'' +
                ", dbSnapshotArn='" + dbSnapshotArn + '\'' +
                ", timezone='" + timezone + '\'' +
                ", iamDatabaseAuthenticationEnabled=" + iamDatabaseAuthenticationEnabled +
                '}';
    }
}
