/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.api.model;

import java.io.Serializable;


public class DomainMembership implements Serializable {

    private static final long serialVersionUID = -2926909548238735458L;
    /**
     * <p>
     * The identifier of the Active Directory Domain.
     * </p>
     */
    private String domain;
    /**
     * <p>
     * The status of the DB instance's Active Directory Domain membership, such as joined, pending-join, failed etc).
     * </p>
     */
    private String status;
    /**
     * <p>
     * The fully qualified domain name of the Active Directory Domain.
     * </p>
     */
    private String fQDN;
    /**
     * <p>
     * The name of the IAM role to be used when making API calls to the Directory Service.
     * </p>
     */
    private String iAMRoleName;

    /**
     * <p>
     * The identifier of the Active Directory Domain.
     * </p>
     *
     * @return The identifier of the Active Directory Domain.
     */

    public String getDomain() {
        return this.domain;
    }

    /**
     * <p>
     * The identifier of the Active Directory Domain.
     * </p>
     *
     * @param domain The identifier of the Active Directory Domain.
     */

    public void setDomain(String domain) {
        this.domain = domain;
    }

    /**
     * <p>
     * The identifier of the Active Directory Domain.
     * </p>
     *
     * @param domain The identifier of the Active Directory Domain.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DomainMembership withDomain(String domain) {
        setDomain(domain);
        return this;
    }

    /**
     * <p>
     * The status of the DB instance's Active Directory Domain membership, such as joined, pending-join, failed etc).
     * </p>
     *
     * @return The status of the DB instance's Active Directory Domain membership, such as joined, pending-join, failed
     * etc).
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The status of the DB instance's Active Directory Domain membership, such as joined, pending-join, failed etc).
     * </p>
     *
     * @param status The status of the DB instance's Active Directory Domain membership, such as joined, pending-join, failed
     *               etc).
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The status of the DB instance's Active Directory Domain membership, such as joined, pending-join, failed etc).
     * </p>
     *
     * @param status The status of the DB instance's Active Directory Domain membership, such as joined, pending-join, failed
     *               etc).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DomainMembership withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * The fully qualified domain name of the Active Directory Domain.
     * </p>
     *
     * @return The fully qualified domain name of the Active Directory Domain.
     */

    public String getFQDN() {
        return this.fQDN;
    }

    /**
     * <p>
     * The fully qualified domain name of the Active Directory Domain.
     * </p>
     *
     * @param fQDN The fully qualified domain name of the Active Directory Domain.
     */

    public void setFQDN(String fQDN) {
        this.fQDN = fQDN;
    }

    /**
     * <p>
     * The fully qualified domain name of the Active Directory Domain.
     * </p>
     *
     * @param fQDN The fully qualified domain name of the Active Directory Domain.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DomainMembership withFQDN(String fQDN) {
        setFQDN(fQDN);
        return this;
    }

    /**
     * <p>
     * The name of the IAM role to be used when making API calls to the Directory Service.
     * </p>
     *
     * @return The name of the IAM role to be used when making API calls to the Directory Service.
     */

    public String getIAMRoleName() {
        return this.iAMRoleName;
    }

    /**
     * <p>
     * The name of the IAM role to be used when making API calls to the Directory Service.
     * </p>
     *
     * @param iAMRoleName The name of the IAM role to be used when making API calls to the Directory Service.
     */

    public void setIAMRoleName(String iAMRoleName) {
        this.iAMRoleName = iAMRoleName;
    }

    /**
     * <p>
     * The name of the IAM role to be used when making API calls to the Directory Service.
     * </p>
     *
     * @param iAMRoleName The name of the IAM role to be used when making API calls to the Directory Service.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DomainMembership withIAMRoleName(String iAMRoleName) {
        setIAMRoleName(iAMRoleName);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and debugging.
     *
     * @return A string representation of this object.
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDomain() != null)
            sb.append("Domain: ").append(getDomain()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getFQDN() != null)
            sb.append("FQDN: ").append(getFQDN()).append(",");
        if (getIAMRoleName() != null)
            sb.append("IAMRoleName: ").append(getIAMRoleName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DomainMembership == false)
            return false;
        DomainMembership other = (DomainMembership) obj;
        if (other.getDomain() == null ^ this.getDomain() == null)
            return false;
        if (other.getDomain() != null && other.getDomain().equals(this.getDomain()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getFQDN() == null ^ this.getFQDN() == null)
            return false;
        if (other.getFQDN() != null && other.getFQDN().equals(this.getFQDN()) == false)
            return false;
        if (other.getIAMRoleName() == null ^ this.getIAMRoleName() == null)
            return false;
        if (other.getIAMRoleName() != null && other.getIAMRoleName().equals(this.getIAMRoleName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDomain() == null) ? 0 : getDomain().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getFQDN() == null) ? 0 : getFQDN().hashCode());
        hashCode = prime * hashCode + ((getIAMRoleName() == null) ? 0 : getIAMRoleName().hashCode());
        return hashCode;
    }

}
