/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.api.model;


import java.io.Serializable;

public class OptionGroupMembership implements Serializable {

    private static final long serialVersionUID = -2257450029047179547L;

    /**
     * <p>
     * The name of the option group that the instance belongs to.
     * </p>
     */
    private String optionGroupName;
    /**
     * <p>
     * The status of the DB instance's option group membership. Valid values are: <code>in-sync</code>,
     * <code>pending-apply</code>, <code>pending-removal</code>, <code>pending-maintenance-apply</code>,
     * <code>pending-maintenance-removal</code>, <code>applying</code>, <code>removing</code>, and <code>failed</code>.
     * </p>
     */
    private String status;

    /**
     * <p>
     * The name of the option group that the instance belongs to.
     * </p>
     *
     * @return The name of the option group that the instance belongs to.
     */

    public String getOptionGroupName() {
        return this.optionGroupName;
    }

    /**
     * <p>
     * The name of the option group that the instance belongs to.
     * </p>
     *
     * @param optionGroupName The name of the option group that the instance belongs to.
     */

    public void setOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
    }

    /**
     * <p>
     * The name of the option group that the instance belongs to.
     * </p>
     *
     * @param optionGroupName The name of the option group that the instance belongs to.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OptionGroupMembership withOptionGroupName(String optionGroupName) {
        setOptionGroupName(optionGroupName);
        return this;
    }

    /**
     * <p>
     * The status of the DB instance's option group membership. Valid values are: <code>in-sync</code>,
     * <code>pending-apply</code>, <code>pending-removal</code>, <code>pending-maintenance-apply</code>,
     * <code>pending-maintenance-removal</code>, <code>applying</code>, <code>removing</code>, and <code>failed</code>.
     * </p>
     *
     * @return The status of the DB instance's option group membership. Valid values are: <code>in-sync</code>,
     * <code>pending-apply</code>, <code>pending-removal</code>, <code>pending-maintenance-apply</code>,
     * <code>pending-maintenance-removal</code>, <code>applying</code>, <code>removing</code>, and
     * <code>failed</code>.
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The status of the DB instance's option group membership. Valid values are: <code>in-sync</code>,
     * <code>pending-apply</code>, <code>pending-removal</code>, <code>pending-maintenance-apply</code>,
     * <code>pending-maintenance-removal</code>, <code>applying</code>, <code>removing</code>, and <code>failed</code>.
     * </p>
     *
     * @param status The status of the DB instance's option group membership. Valid values are: <code>in-sync</code>,
     *               <code>pending-apply</code>, <code>pending-removal</code>, <code>pending-maintenance-apply</code>,
     *               <code>pending-maintenance-removal</code>, <code>applying</code>, <code>removing</code>, and
     *               <code>failed</code>.
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The status of the DB instance's option group membership. Valid values are: <code>in-sync</code>,
     * <code>pending-apply</code>, <code>pending-removal</code>, <code>pending-maintenance-apply</code>,
     * <code>pending-maintenance-removal</code>, <code>applying</code>, <code>removing</code>, and <code>failed</code>.
     * </p>
     *
     * @param status The status of the DB instance's option group membership. Valid values are: <code>in-sync</code>,
     *               <code>pending-apply</code>, <code>pending-removal</code>, <code>pending-maintenance-apply</code>,
     *               <code>pending-maintenance-removal</code>, <code>applying</code>, <code>removing</code>, and
     *               <code>failed</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OptionGroupMembership withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and debugging.
     *
     * @return A string representation of this object.
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getOptionGroupName() != null)
            sb.append("OptionGroupName: ").append(getOptionGroupName()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof OptionGroupMembership == false)
            return false;
        OptionGroupMembership other = (OptionGroupMembership) obj;
        if (other.getOptionGroupName() == null ^ this.getOptionGroupName() == null)
            return false;
        if (other.getOptionGroupName() != null && other.getOptionGroupName().equals(this.getOptionGroupName()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getOptionGroupName() == null) ? 0 : getOptionGroupName().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        return hashCode;
    }
}
