/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.api.model;

import java.io.Serializable;
import java.util.Objects;

public class PendingModifiedValues implements Serializable {


    private static final long serialVersionUID = -4281224398044760991L;

    /**
     * <p>
     * Contains the new <code>DBInstanceClass</code> for the DB instance that will be applied or is in progress.
     * </p>
     */
    private String dBInstanceClass;
    /**
     * <p>
     * Contains the new <code>AllocatedStorage</code> size for the DB instance that will be applied or is in progress.
     * </p>
     */
    private Integer allocatedStorage;
    /**
     * <p>
     * Contains the pending or in-progress change of the master credentials for the DB instance.
     * </p>
     */
    private String masterUserPassword;
    /**
     * <p>
     * Specifies the pending port for the DB instance.
     * </p>
     */
    private Integer port;
    /**
     * <p>
     * Specifies the pending number of days for which automated backups are retained.
     * </p>
     */
    private Integer backupRetentionPeriod;
    /**
     * <p>
     * Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.
     * </p>
     */
    private boolean multiAZ;
    /**
     * <p>
     * Indicates the database engine version.
     * </p>
     */
    private String engineVersion;
    /**
     * <p>
     * The license model for the DB instance.
     * </p>
     * <p>
     * Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
     * <code>general-public-license</code>
     * </p>
     */
    private String licenseModel;
    /**
     * <p>
     * Specifies the new Provisioned IOPS value for the DB instance that will be applied or is being applied.
     * </p>
     */
    private Integer iops;
    /**
     * <p>
     * Contains the new <code>DBInstanceIdentifier</code> for the DB instance that will be applied or is in progress.
     * </p>
     */
    private String dBInstanceIdentifier;
    /**
     * <p>
     * Specifies the storage type to be associated with the DB instance.
     * </p>
     */
    private String storageType;
    /**
     * <p>
     * Specifies the identifier of the CA certificate for the DB instance.
     * </p>
     */
    private String cACertificateIdentifier;
    /**
     * <p>
     * The new DB subnet group for the DB instance.
     * </p>
     */
    private String dBSubnetGroupName;

    /**
     * <p>
     * Contains the new <code>DBInstanceClass</code> for the DB instance that will be applied or is in progress.
     * </p>
     *
     * @return Contains the new <code>DBInstanceClass</code> for the DB instance that will be applied or is in progress.
     */

    public String getDBInstanceClass() {
        return this.dBInstanceClass;
    }

    /**
     * <p>
     * Contains the new <code>DBInstanceClass</code> for the DB instance that will be applied or is in progress.
     * </p>
     *
     * @param dBInstanceClass Contains the new <code>DBInstanceClass</code> for the DB instance that will be applied or is in progress.
     */

    public void setDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
    }

    /**
     * <p>
     * Contains the new <code>DBInstanceClass</code> for the DB instance that will be applied or is in progress.
     * </p>
     *
     * @param dBInstanceClass Contains the new <code>DBInstanceClass</code> for the DB instance that will be applied or is in progress.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PendingModifiedValues withDBInstanceClass(String dBInstanceClass) {
        setDBInstanceClass(dBInstanceClass);
        return this;
    }

    /**
     * <p>
     * Contains the new <code>AllocatedStorage</code> size for the DB instance that will be applied or is in progress.
     * </p>
     *
     * @return Contains the new <code>AllocatedStorage</code> size for the DB instance that will be applied or is in
     * progress.
     */

    public Integer getAllocatedStorage() {
        return this.allocatedStorage;
    }

    /**
     * <p>
     * Contains the new <code>AllocatedStorage</code> size for the DB instance that will be applied or is in progress.
     * </p>
     *
     * @param allocatedStorage Contains the new <code>AllocatedStorage</code> size for the DB instance that will be applied or is in
     *                         progress.
     */

    public void setAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
    }

    /**
     * <p>
     * Contains the new <code>AllocatedStorage</code> size for the DB instance that will be applied or is in progress.
     * </p>
     *
     * @param allocatedStorage Contains the new <code>AllocatedStorage</code> size for the DB instance that will be applied or is in
     *                         progress.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PendingModifiedValues withAllocatedStorage(Integer allocatedStorage) {
        setAllocatedStorage(allocatedStorage);
        return this;
    }

    /**
     * <p>
     * Contains the pending or in-progress change of the master credentials for the DB instance.
     * </p>
     *
     * @return Contains the pending or in-progress change of the master credentials for the DB instance.
     */

    public String getMasterUserPassword() {
        return this.masterUserPassword;
    }

    /**
     * <p>
     * Contains the pending or in-progress change of the master credentials for the DB instance.
     * </p>
     *
     * @param masterUserPassword Contains the pending or in-progress change of the master credentials for the DB instance.
     */

    public void setMasterUserPassword(String masterUserPassword) {
        this.masterUserPassword = masterUserPassword;
    }

    /**
     * <p>
     * Contains the pending or in-progress change of the master credentials for the DB instance.
     * </p>
     *
     * @param masterUserPassword Contains the pending or in-progress change of the master credentials for the DB instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PendingModifiedValues withMasterUserPassword(String masterUserPassword) {
        setMasterUserPassword(masterUserPassword);
        return this;
    }

    /**
     * <p>
     * Specifies the pending port for the DB instance.
     * </p>
     *
     * @return Specifies the pending port for the DB instance.
     */

    public Integer getPort() {
        return this.port;
    }

    /**
     * <p>
     * Specifies the pending port for the DB instance.
     * </p>
     *
     * @param port Specifies the pending port for the DB instance.
     */

    public void setPort(Integer port) {
        this.port = port;
    }

    /**
     * <p>
     * Specifies the pending port for the DB instance.
     * </p>
     *
     * @param port Specifies the pending port for the DB instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PendingModifiedValues withPort(Integer port) {
        setPort(port);
        return this;
    }

    /**
     * <p>
     * Specifies the pending number of days for which automated backups are retained.
     * </p>
     *
     * @return Specifies the pending number of days for which automated backups are retained.
     */

    public Integer getBackupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    /**
     * <p>
     * Specifies the pending number of days for which automated backups are retained.
     * </p>
     *
     * @param backupRetentionPeriod Specifies the pending number of days for which automated backups are retained.
     */

    public void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.backupRetentionPeriod = backupRetentionPeriod;
    }

    /**
     * <p>
     * Specifies the pending number of days for which automated backups are retained.
     * </p>
     *
     * @param backupRetentionPeriod Specifies the pending number of days for which automated backups are retained.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PendingModifiedValues withBackupRetentionPeriod(Integer backupRetentionPeriod) {
        setBackupRetentionPeriod(backupRetentionPeriod);
        return this;
    }

    /**
     * <p>
     * Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.
     * </p>
     *
     * @return Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.
     */

    public boolean getMultiAZ() {
        return this.multiAZ;
    }

    /**
     * <p>
     * Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.
     * </p>
     *
     * @param multiAZ Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.
     */

    public void setMultiAZ(boolean multiAZ) {
        this.multiAZ = multiAZ;
    }

    /**
     * <p>
     * Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.
     * </p>
     *
     * @param multiAZ Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PendingModifiedValues withMultiAZ(boolean multiAZ) {
        setMultiAZ(multiAZ);
        return this;
    }

    /**
     * <p>
     * Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.
     * </p>
     *
     * @return Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.
     */

    public boolean isMultiAZ() {
        return this.multiAZ;
    }

    /**
     * <p>
     * Indicates the database engine version.
     * </p>
     *
     * @return Indicates the database engine version.
     */

    public String getEngineVersion() {
        return this.engineVersion;
    }

    /**
     * <p>
     * Indicates the database engine version.
     * </p>
     *
     * @param engineVersion Indicates the database engine version.
     */

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    /**
     * <p>
     * Indicates the database engine version.
     * </p>
     *
     * @param engineVersion Indicates the database engine version.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PendingModifiedValues withEngineVersion(String engineVersion) {
        setEngineVersion(engineVersion);
        return this;
    }

    /**
     * <p>
     * The license model for the DB instance.
     * </p>
     * <p>
     * Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
     * <code>general-public-license</code>
     * </p>
     *
     * @return <p>The license model for the DB instance.</p>
     * <p>
     * Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
     * <code>general-public-license</code>
     * </p>
     */

    public String getLicenseModel() {
        return this.licenseModel;
    }

    /**
     * <p>
     * The license model for the DB instance.
     * </p>
     * <p>
     * Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
     * <code>general-public-license</code>
     * </p>
     *
     * @param licenseModel <p>The license model for the DB instance.</p>
     *                     <p>
     *                     Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
     *                     <code>general-public-license</code>
     *                     </p>
     */

    public void setLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
    }

    /**
     * <p>
     * The license model for the DB instance.
     * </p>
     * <p>
     * Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
     * <code>general-public-license</code>
     * </p>
     *
     * @param licenseModel <p>The license model for the DB instance.</p>
     *                     <p>
     *                     Valid values: <code>license-included</code> | <code>bring-your-own-license</code> |
     *                     <code>general-public-license</code>
     *                     </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PendingModifiedValues withLicenseModel(String licenseModel) {
        setLicenseModel(licenseModel);
        return this;
    }

    /**
     * <p>
     * Specifies the new Provisioned IOPS value for the DB instance that will be applied or is being applied.
     * </p>
     *
     * @return Specifies the new Provisioned IOPS value for the DB instance that will be applied or is being applied.
     */

    public Integer getIops() {
        return this.iops;
    }

    /**
     * <p>
     * Specifies the new Provisioned IOPS value for the DB instance that will be applied or is being applied.
     * </p>
     *
     * @param iops <p>Specifies the new Provisioned IOPS value for the DB instance that will be applied or is being applied.</p>
     */

    public void setIops(Integer iops) {
        this.iops = iops;
    }

    /**
     * <p>
     * Specifies the new Provisioned IOPS value for the DB instance that will be applied or is being applied.
     * </p>
     *
     * @param iops Specifies the new Provisioned IOPS value for the DB instance that will be applied or is being applied.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PendingModifiedValues withIops(Integer iops) {
        setIops(iops);
        return this;
    }

    /**
     * <p>
     * Contains the new <code>DBInstanceIdentifier</code> for the DB instance that will be applied or is in progress.
     * </p>
     *
     * @return Contains the new <code>DBInstanceIdentifier</code> for the DB instance that will be applied or is in
     * progress.
     */

    public String getDBInstanceIdentifier() {
        return this.dBInstanceIdentifier;
    }

    /**
     * <p>
     * Contains the new <code>DBInstanceIdentifier</code> for the DB instance that will be applied or is in progress.
     * </p>
     *
     * @param dBInstanceIdentifier Contains the new <code>DBInstanceIdentifier</code> for the DB instance that will be applied or is in
     *                             progress.
     */

    public void setDBInstanceIdentifier(String dBInstanceIdentifier) {
        this.dBInstanceIdentifier = dBInstanceIdentifier;
    }

    /**
     * <p>
     * Contains the new <code>DBInstanceIdentifier</code> for the DB instance that will be applied or is in progress.
     * </p>
     *
     * @param dBInstanceIdentifier Contains the new <code>DBInstanceIdentifier</code> for the DB instance that will be applied or is in
     *                             progress.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PendingModifiedValues withDBInstanceIdentifier(String dBInstanceIdentifier) {
        setDBInstanceIdentifier(dBInstanceIdentifier);
        return this;
    }

    /**
     * <p>
     * Specifies the storage type to be associated with the DB instance.
     * </p>
     *
     * @return Specifies the storage type to be associated with the DB instance.
     */

    public String getStorageType() {
        return this.storageType;
    }

    /**
     * <p>
     * Specifies the storage type to be associated with the DB instance.
     * </p>
     *
     * @param storageType Specifies the storage type to be associated with the DB instance.
     */

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    /**
     * <p>
     * Specifies the storage type to be associated with the DB instance.
     * </p>
     *
     * @param storageType Specifies the storage type to be associated with the DB instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PendingModifiedValues withStorageType(String storageType) {
        setStorageType(storageType);
        return this;
    }

    /**
     * <p>
     * Specifies the identifier of the CA certificate for the DB instance.
     * </p>
     *
     * @return Specifies the identifier of the CA certificate for the DB instance.
     */

    public String getCACertificateIdentifier() {
        return this.cACertificateIdentifier;
    }

    /**
     * <p>
     * Specifies the identifier of the CA certificate for the DB instance.
     * </p>
     *
     * @param cACertificateIdentifier Specifies the identifier of the CA certificate for the DB instance.
     */

    public void setCACertificateIdentifier(String cACertificateIdentifier) {
        this.cACertificateIdentifier = cACertificateIdentifier;
    }

    /**
     * <p>
     * Specifies the identifier of the CA certificate for the DB instance.
     * </p>
     *
     * @param cACertificateIdentifier Specifies the identifier of the CA certificate for the DB instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PendingModifiedValues withCACertificateIdentifier(String cACertificateIdentifier) {
        setCACertificateIdentifier(cACertificateIdentifier);
        return this;
    }

    /**
     * <p>
     * The new DB subnet group for the DB instance.
     * </p>
     *
     * @return The new DB subnet group for the DB instance.
     */

    public String getDBSubnetGroupName() {
        return this.dBSubnetGroupName;
    }

    /**
     * <p>
     * The new DB subnet group for the DB instance.
     * </p>
     *
     * @param dBSubnetGroupName The new DB subnet group for the DB instance.
     */

    public void setDBSubnetGroupName(String dBSubnetGroupName) {
        this.dBSubnetGroupName = dBSubnetGroupName;
    }

    /**
     * <p>
     * The new DB subnet group for the DB instance.
     * </p>
     *
     * @param dBSubnetGroupName The new DB subnet group for the DB instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PendingModifiedValues withDBSubnetGroupName(String dBSubnetGroupName) {
        setDBSubnetGroupName(dBSubnetGroupName);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and debugging.
     *
     * @return A string representation of this object.
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "PendingModifiedValues{" +
                "dBInstanceClass='" + dBInstanceClass + '\'' +
                ", allocatedStorage=" + allocatedStorage +
                ", masterUserPassword='" + masterUserPassword + '\'' +
                ", port=" + port +
                ", backupRetentionPeriod=" + backupRetentionPeriod +
                ", multiAZ=" + multiAZ +
                ", engineVersion='" + engineVersion + '\'' +
                ", licenseModel='" + licenseModel + '\'' +
                ", iops=" + iops +
                ", dBInstanceIdentifier='" + dBInstanceIdentifier + '\'' +
                ", storageType='" + storageType + '\'' +
                ", cACertificateIdentifier='" + cACertificateIdentifier + '\'' +
                ", dBSubnetGroupName='" + dBSubnetGroupName + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PendingModifiedValues that = (PendingModifiedValues) o;
        return multiAZ == that.multiAZ &&
                Objects.equals(dBInstanceClass, that.dBInstanceClass) &&
                Objects.equals(allocatedStorage, that.allocatedStorage) &&
                Objects.equals(masterUserPassword, that.masterUserPassword) &&
                Objects.equals(port, that.port) &&
                Objects.equals(backupRetentionPeriod, that.backupRetentionPeriod) &&
                Objects.equals(engineVersion, that.engineVersion) &&
                Objects.equals(licenseModel, that.licenseModel) &&
                Objects.equals(iops, that.iops) &&
                Objects.equals(dBInstanceIdentifier, that.dBInstanceIdentifier) &&
                Objects.equals(storageType, that.storageType) &&
                Objects.equals(cACertificateIdentifier, that.cACertificateIdentifier) &&
                Objects.equals(dBSubnetGroupName, that.dBSubnetGroupName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(dBInstanceClass, allocatedStorage, masterUserPassword, port, backupRetentionPeriod, multiAZ, engineVersion, licenseModel, iops, dBInstanceIdentifier, storageType, cACertificateIdentifier, dBSubnetGroupName);
    }
}
