/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.api.model;

import java.io.Serializable;

public class RecurringCharge implements Serializable {

    /**
     * <p>
     * The amount of the recurring charge.
     * </p>
     */
    private Double recurringChargeAmount;
    /**
     * <p>
     * The frequency of the recurring charge.
     * </p>
     */
    private String recurringChargeFrequency;

    /**
     * <p>
     * The amount of the recurring charge.
     * </p>
     *
     * @return The amount of the recurring charge.
     */

    public Double getRecurringChargeAmount() {
        return this.recurringChargeAmount;
    }

    /**
     * <p>
     * The amount of the recurring charge.
     * </p>
     *
     * @param recurringChargeAmount The amount of the recurring charge.
     */

    public void setRecurringChargeAmount(Double recurringChargeAmount) {
        this.recurringChargeAmount = recurringChargeAmount;
    }

    /**
     * <p>
     * The amount of the recurring charge.
     * </p>
     *
     * @param recurringChargeAmount The amount of the recurring charge.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RecurringCharge withRecurringChargeAmount(Double recurringChargeAmount) {
        setRecurringChargeAmount(recurringChargeAmount);
        return this;
    }

    /**
     * <p>
     * The frequency of the recurring charge.
     * </p>
     *
     * @return The frequency of the recurring charge.
     */

    public String getRecurringChargeFrequency() {
        return this.recurringChargeFrequency;
    }

    /**
     * <p>
     * The frequency of the recurring charge.
     * </p>
     *
     * @param recurringChargeFrequency The frequency of the recurring charge.
     */

    public void setRecurringChargeFrequency(String recurringChargeFrequency) {
        this.recurringChargeFrequency = recurringChargeFrequency;
    }

    /**
     * <p>
     * The frequency of the recurring charge.
     * </p>
     *
     * @param recurringChargeFrequency The frequency of the recurring charge.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RecurringCharge withRecurringChargeFrequency(String recurringChargeFrequency) {
        setRecurringChargeFrequency(recurringChargeFrequency);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and debugging.
     *
     * @return A string representation of this object.
     * @see Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getRecurringChargeAmount() != null)
            sb.append("RecurringChargeAmount: ").append(getRecurringChargeAmount()).append(",");
        if (getRecurringChargeFrequency() != null)
            sb.append("RecurringChargeFrequency: ").append(getRecurringChargeFrequency());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof RecurringCharge == false)
            return false;
        RecurringCharge other = (RecurringCharge) obj;
        if (other.getRecurringChargeAmount() == null ^ this.getRecurringChargeAmount() == null)
            return false;
        if (other.getRecurringChargeAmount() != null && other.getRecurringChargeAmount().equals(this.getRecurringChargeAmount()) == false)
            return false;
        if (other.getRecurringChargeFrequency() == null ^ this.getRecurringChargeFrequency() == null)
            return false;
        if (other.getRecurringChargeFrequency() != null && other.getRecurringChargeFrequency().equals(this.getRecurringChargeFrequency()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getRecurringChargeAmount() == null) ? 0 : getRecurringChargeAmount().hashCode());
        hashCode = prime * hashCode + ((getRecurringChargeFrequency() == null) ? 0 : getRecurringChargeFrequency().hashCode());
        return hashCode;
    }


}
