/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.api.model;

public enum SourceType {

    DbInstance("db-instance"),
    DbParameterGroup("db-parameter-group"),
    DbSecurityGroup("db-security-group"),
    DbSnapshot("db-snapshot"),
    DbCluster("db-cluster"),
    DbClusterSnapshot("db-cluster-snapshot");

    private String value;

    SourceType() {
    }

    SourceType(String value) {
        this.value = value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value real value
     * @return SourceType corresponding to the value
     */
    public static SourceType fromValue(String value) {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }

        for (SourceType enumEntry : SourceType.values()) {
            if (enumEntry.toString().equals(value)) {
                return enumEntry;
            }
        }

        throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
    }

    @Override
    public String toString() {
        return this.value;
    }
}
