/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.api.model;


import java.io.Serializable;

public class Subnet implements Serializable {

    private static final long serialVersionUID = -3001659266868280896L;

    /**
     * <p>
     * Specifies the identifier of the subnet.
     * </p>
     */
    private String subnetIdentifier;

    /**
     * <p> Specifies the availability zone of the subnet.</p>
     */
    private String subnetAvailabilityZone;
    /**
     * <p>
     * Specifies the status of the subnet.
     * </p>
     */
    private String subnetStatus;

    /**
     * <p>
     * Specifies the identifier of the subnet.
     * </p>
     *
     * @return Specifies the identifier of the subnet.
     */

    public String getSubnetIdentifier() {
        return this.subnetIdentifier;
    }

    /**
     * <p>
     * Specifies the identifier of the subnet.
     * </p>
     *
     * @param subnetIdentifier Specifies the identifier of the subnet.
     */

    public void setSubnetIdentifier(String subnetIdentifier) {
        this.subnetIdentifier = subnetIdentifier;
    }

    /**
     * <p>
     * Specifies the identifier of the subnet.
     * </p>
     *
     * @param subnetIdentifier Specifies the identifier of the subnet.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Subnet withSubnetIdentifier(String subnetIdentifier) {
        setSubnetIdentifier(subnetIdentifier);
        return this;
    }

    /**
     * @return AvailabilityZone
     * <p> Specifies the availability zone of the subnet.</p>
     */
    public String getSubnetAvailabilityZone() {
        return this.subnetAvailabilityZone;
    }

    /**
     * @param subnetAvailabilityZone <p> Specifies the availability zone of the subnet.</p>
     */
    public void setSubnetAvailabilityZone(String subnetAvailabilityZone) {
        this.subnetAvailabilityZone = subnetAvailabilityZone;
    }

    /**
     * @param subnetAvailabilityZone <p> Specifies the availability zone of the subnet.</p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Subnet withSubnetAvailabilityZone(String subnetAvailabilityZone) {
        setSubnetAvailabilityZone(subnetAvailabilityZone);
        return this;
    }

    /**
     * <p>
     * Specifies the status of the subnet.
     * </p>
     *
     * @return Specifies the status of the subnet.
     */

    public String getSubnetStatus() {
        return this.subnetStatus;
    }

    /**
     * <p>
     * Specifies the status of the subnet.
     * </p>
     *
     * @param subnetStatus Specifies the status of the subnet.
     */

    public void setSubnetStatus(String subnetStatus) {
        this.subnetStatus = subnetStatus;
    }

    /**
     * <p>
     * Specifies the status of the subnet.
     * </p>
     *
     * @param subnetStatus Specifies the status of the subnet.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Subnet withSubnetStatus(String subnetStatus) {
        setSubnetStatus(subnetStatus);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and debugging.
     *
     * @return A string representation of this object.
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSubnetIdentifier() != null)
            sb.append("SubnetIdentifier: ").append(getSubnetIdentifier()).append(",");
        if (getSubnetAvailabilityZone() != null)
            sb.append("SubnetAvailabilityZone: ").append(getSubnetAvailabilityZone()).append(",");
        if (getSubnetStatus() != null)
            sb.append("SubnetStatus: ").append(getSubnetStatus());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Subnet == false)
            return false;
        Subnet other = (Subnet) obj;
        if (other.getSubnetIdentifier() == null ^ this.getSubnetIdentifier() == null)
            return false;
        if (other.getSubnetIdentifier() != null && other.getSubnetIdentifier().equals(this.getSubnetIdentifier()) == false)
            return false;
        if (other.getSubnetAvailabilityZone() == null ^ this.getSubnetAvailabilityZone() == null)
            return false;
        if (other.getSubnetAvailabilityZone() != null && other.getSubnetAvailabilityZone().equals(this.getSubnetAvailabilityZone()) == false)
            return false;
        if (other.getSubnetStatus() == null ^ this.getSubnetStatus() == null)
            return false;
        if (other.getSubnetStatus() != null && other.getSubnetStatus().equals(this.getSubnetStatus()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSubnetIdentifier() == null) ? 0 : getSubnetIdentifier().hashCode());
        hashCode = prime * hashCode + ((getSubnetAvailabilityZone() == null) ? 0 : getSubnetAvailabilityZone().hashCode());
        hashCode = prime * hashCode + ((getSubnetStatus() == null) ? 0 : getSubnetStatus().hashCode());
        return hashCode;
    }
}
