/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.api.model;


import java.io.Serializable;

public class VpcSecurityGroupMembership implements Serializable {

    private static final long serialVersionUID = -6359998822551904351L;


    /**
     * <p>
     * The name of the VPC security group.
     * </p>
     */
    private String vpcSecurityGroupId;
    /**
     * <p>
     * The status of the VPC security group.
     * </p>
     */
    private String status;

    public VpcSecurityGroupMembership() {
    }

    /**
     * <p>
     * The name of the VPC security group.
     * </p>
     *
     * @return The name of the VPC security group.
     */
    public String getVpcSecurityGroupId() {
        return this.vpcSecurityGroupId;
    }

    /**
     * <p>
     * The name of the VPC security group.
     * </p>
     *
     * @param vpcSecurityGroupId The name of the VPC security group.
     */
    public void setVpcSecurityGroupId(String vpcSecurityGroupId) {
        this.vpcSecurityGroupId = vpcSecurityGroupId;
    }

    /**
     * <p>
     * The status of the VPC security group.
     * </p>
     *
     * @return The status of the VPC security group.
     */
    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The status of the VPC security group.
     * </p>
     *
     * @param status The status of the VPC security group.
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * Returns a string representation of this object; useful for testing and debugging.
     *
     * @return A string representation of this object.
     * @see java.lang.Object#toString()
     */

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVpcSecurityGroupId() != null) {
            sb.append("VpcSecurityGroupId: ").append(this.getVpcSecurityGroupId()).append(",");
        }

        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus());
        }

        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        } else if (obj == null) {
            return false;
        } else if (!(obj instanceof VpcSecurityGroupMembership)) {
            return false;
        } else {
            VpcSecurityGroupMembership other = (VpcSecurityGroupMembership) obj;
            return other.getVpcSecurityGroupId() == null ^ this.getVpcSecurityGroupId() == null ? false : (other.getVpcSecurityGroupId() != null && !other.getVpcSecurityGroupId().equals(this.getVpcSecurityGroupId()) ? false : (other.getStatus() == null ^ this.getStatus() == null ? false : other.getStatus() == null || other.getStatus().equals(this.getStatus())));
        }
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = prime * hashCode + (this.getVpcSecurityGroupId() == null ? 0 : this.getVpcSecurityGroupId().hashCode());
        hashCode = prime * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        return hashCode;
    }
}
