/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.config;

import org.mule.extension.aws.commons.internal.config.AWSConfig;
import org.mule.extension.rds.internal.connection.provider.AssumeRoleConnectionProvider;
import org.mule.extension.rds.internal.connection.provider.BasicConnectionProvider;
import org.mule.extension.rds.internal.operation.DBInstanceOperations;
import org.mule.extension.rds.internal.operation.DBSnapshotOperations;
import org.mule.extension.rds.internal.operation.EventOperations;
import org.mule.extension.rds.internal.operation.ReservedDBInstanceOperations;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;

@Configuration(name = "config")
@DisplayName("Configuration")
@Operations({
        DBInstanceOperations.class,
        DBSnapshotOperations.class,
        ReservedDBInstanceOperations.class,
        EventOperations.class
})
@ConnectionProviders({
        BasicConnectionProvider.class,
        AssumeRoleConnectionProvider.class
})
public class RDSConfiguration extends AWSConfig {
}