/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.connection;


import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.AmazonRDSAsync;
import com.amazonaws.services.rds.model.AmazonRDSException;
import org.mule.extension.aws.commons.internal.connection.AWSConnection;
import org.mule.extension.aws.commons.internal.exception.AWSConnectionException;

public class RDSConnection extends AWSConnection<AmazonRDS, AmazonRDSAsync> {

    public RDSConnection(AmazonRDS awsClient, AmazonRDSAsync awsAsyncClient) {
        super(awsClient, awsAsyncClient);
    }

    @Override
    public void validate() throws AWSConnectionException {
        try {
            getAwsClient().describeDBInstances();
        } catch (AmazonRDSException e) {
            throw new AWSConnectionException("An error occurred while trying to validate the connection.", e);
        }
    }
}
