/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.connection.provider;

import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.AmazonRDSAsync;
import com.amazonaws.services.rds.AmazonRDSAsyncClientBuilder;
import com.amazonaws.services.rds.AmazonRDSClientBuilder;
import org.mule.extension.aws.commons.internal.connection.AWSConnection;
import org.mule.extension.aws.commons.internal.connection.provider.AssumeRoleConnectionProvider;

import java.util.function.BiFunction;

public class ParentAssumeRoleConnectionProvider<CONNECTION extends AWSConnection<AmazonRDS, AmazonRDSAsync>> extends AssumeRoleConnectionProvider<AmazonRDS, AmazonRDSAsync, AmazonRDSClientBuilder, AmazonRDSAsyncClientBuilder, CONNECTION> {

    public ParentAssumeRoleConnectionProvider(BiFunction<AmazonRDS, AmazonRDSAsync, CONNECTION> connectionConstructor) {
        super(connectionConstructor, AmazonRDSClientBuilder.standard(), AmazonRDSAsyncClientBuilder.standard());
    }
}
