/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.error;

import org.mule.runtime.extension.api.error.ErrorTypeDefinition;


public enum RDSErrorType implements ErrorTypeDefinition<RDSErrorType> {

    AuthorizationNotFound,
    DBClusterNotFoundFault,
    DBInstanceAlreadyExists,
    DBParameterGroupNotFound,
    DBSecurityGroupNotFound,
    DBSubnetGroupDoesNotCoverEnoughAZs,
    DBSubnetGroupNotFoundFault,
    InvalidDBClusterStateFault,
    DomainNotFoundFault,
    InstanceQuotaExceeded,
    InsufficientDBInstanceCapacity,
    InvalidSubnet,
    DBInstanceNotFound,
    DBSnapshotAlreadyExists,
    InvalidDBInstanceState,
    SnapshotQuotaExceeded,
    InvalidVPCNetworkStateFault,
    KMSKeyNotAccessibleFault,
    OptionGroupNotFoundFault,
    ProvisionedIopsNotAvailableInAZFault,
    StorageQuotaExceeded,
    StorageTypeNotSupported,
    CertificateNotFound,
    DBUpgradeDependencyFailure,
    InvalidDBSecurityGroupState,
    DBSnapshotNotFound,
    InvalidDBSnapshotState,
    InvalidRestoreFault,
    PointInTimeRestoreNotEnabled,
    ReservedDBInstanceNotFound,
    ReservedDBInstancesOfferingNotFound,
    AccessDeniedException,
    IncompleteSignature,
    InternalFailure,
    InvalidAction,
    InvalidClientTokenId,
    InvalidParameterCombination,
    InvalidParameterValue,
    InvalidQueryParameter,
    MalformedQueryString,
    MissingAction,
    MissingAuthenticationToken,
    MissingParameter,
    OptInRequired,
    RequestExpired,
    ServiceUnavailable,
    ThrottlingException,
    ValidationError,
    Unknown
}

