/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.extension;

import org.mule.extension.rds.internal.config.RDSConfiguration;
import org.mule.extension.rds.internal.error.RDSErrorType;
import org.mule.extension.rds.internal.error.RDSExceptionHandler;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.OnException;
import org.mule.runtime.extension.api.annotation.dsl.xml.Xml;
import org.mule.runtime.extension.api.annotation.error.ErrorTypes;
import org.mule.runtime.extension.api.annotation.license.RequiresEnterpriseLicense;

import static org.mule.runtime.api.meta.Category.SELECT;

@Extension(name = "Amazon RDS", category = SELECT)
@Configurations(RDSConfiguration.class)
@Xml(prefix = "rds")
@RequiresEnterpriseLicense(allowEvaluationLicense = true)
@OnException(RDSExceptionHandler.class)
@ErrorTypes(RDSErrorType.class)
public class RDSExtension {

}