/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.operation;


import org.mule.connectors.atlantic.commons.builder.lambda.function.BiFunction;
import org.mule.connectors.commons.template.service.ConnectorService;
import org.mule.extension.aws.commons.internal.operation.AWSOperations;
import org.mule.extension.rds.internal.config.RDSConfiguration;
import org.mule.extension.rds.internal.connection.RDSConnection;


public class RDSOperations<SERVICE extends ConnectorService> extends AWSOperations<RDSConfiguration, RDSConnection, SERVICE> {

    protected static final String SECURITY = "Security";
    protected static final String MONITORING = "Monitoring";
    protected static final String STORAGE_AND_MAINTENANCE = "Storage and Maintenance";

    public RDSOperations(BiFunction<RDSConfiguration, RDSConnection, SERVICE> serviceConstructor) {
        super(serviceConstructor);
    }
}
