/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.operation.group.dbinstance;

import org.mule.extension.rds.api.model.Tag;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

import java.util.List;

public class CreationDBInstanceParameterGroup extends DBInstanceParameterGroup {

    @Parameter
    @DisplayName("Availability Zone")
    @Placement(order = 1)
    @Optional
    private String availabilityZone;

    @Parameter
    @DisplayName("DB Name")
    @Placement(order = 4)
    @Optional
    private String dbName;

    @Parameter
    @DisplayName("DB Port Number")
    @Placement(order = 5)
    @Optional
    private Integer port;

    @Parameter
    @Placement(order = 7)
    private String engine;

    @Parameter
    @DisplayName("Character Set Name")
    @Placement(order = 12)
    @Optional
    private String characterSetName;

    @Parameter
    @Placement(order = 14)
    @Optional
    private List<Tag> tags;

    @Parameter
    @DisplayName("Time Zone")
    @Placement(order = 15)
    @Optional
    private String timezone;

    public String getAvailabilityZone() {
        return availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getEngine() {
        return engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getDbName() {
        return dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getCharacterSetName() {
        return characterSetName;
    }

    public void setCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
    }

    public List<Tag> getTags() {
        return tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public String getTimezone() {
        return timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }
}
