/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.operation.group.dbinstance;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

public class DBInstanceParameterGroup {

    @Parameter
    @DisplayName("DB Instance Class")
    @Placement(order = 1)
    @Optional
    private String dbInstanceClass;

    @Parameter
    @DisplayName("DB Instance Identifier")
    @Placement(order = 2)
    private String dbInstanceIdentifier;

    @Parameter
    @DisplayName("DB Parameter Group Name")
    @Placement(order = 3)
    @Optional
    private String dbParameterGroupName;

    @Parameter
    @Placement(order = 5)
    @Optional
    private String domain;

    @Parameter
    @DisplayName("Engine Version")
    @Placement(order = 6)
    @Optional
    private String engineVersion;

    @Parameter
    @DisplayName("IOPS")
    @Placement(order = 7)
    @Optional
    private Integer iops;

    @Parameter
    @DisplayName("Multi AZ")
    @Placement(order = 8)
    @Optional(defaultValue = "false")
    private boolean multiAZ;

    @Parameter
    @DisplayName("Option Group Name")
    @Placement(order = 10)
    @Optional
    private String optionGroupName;

    public String getDbInstanceClass() {
        return dbInstanceClass;
    }

    public void setDbInstanceClass(String dbInstanceClass) {
        this.dbInstanceClass = dbInstanceClass;
    }

    public String getDbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    public void setDbInstanceIdentifier(String dbInstanceIdentifier) {
        this.dbInstanceIdentifier = dbInstanceIdentifier;
    }

    public String getDbParameterGroupName() {
        return dbParameterGroupName;
    }

    public void setDbParameterGroupName(String dbParameterGroupName) {
        this.dbParameterGroupName = dbParameterGroupName;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getEngineVersion() {
        return engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public Integer getIops() {
        return iops;
    }

    public void setIops(Integer iops) {
        this.iops = iops;
    }

    public boolean isMultiAZ() {
        return multiAZ;
    }

    public void setMultiAZ(boolean multiAZ) {
        this.multiAZ = multiAZ;
    }

    public String getOptionGroupName() {
        return optionGroupName;
    }

    public void setOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
    }
}
