/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.operation.group.dbinstance;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

public class ModificationDBInstanceParameterGroup extends DBInstanceParameterGroup {

    @Parameter
    @DisplayName("DB Port Number")
    @Placement(order = 4)
    @Optional
    private Integer dbPortNumber;

    @Parameter
    @DisplayName("New DB Instance Identifier")
    @Placement(order = 9)
    @Optional
    private String newDBInstanceIdentifier;

    public Integer getDbPortNumber() {
        return dbPortNumber;
    }

    public void setDbPortNumber(Integer dbPortNumber) {
        this.dbPortNumber = dbPortNumber;
    }

    public String getNewDBInstanceIdentifier() {
        return newDBInstanceIdentifier;
    }

    public void setNewDBInstanceIdentifier(String newDBInstanceIdentifier) {
        this.newDBInstanceIdentifier = newDBInstanceIdentifier;
    }
}
