/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.operation.group.security;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

import java.util.List;

public class AlterationSecurityParameterGroup extends SecurityParameterGroup {

    @Parameter
    @DisplayName("DB Security Groups")
    @Placement(order = 2)
    @Optional
    private List<String> dbSecurityGroups;

    @Parameter
    @DisplayName("Master User Password")
    @Placement(order = 7)
    @Optional
    private String masterUserPassword;

    @Parameter
    @DisplayName("VPC Security Group IDs")
    @Placement(order = 11)
    @Optional
    private List<String> vpcSecurityGroupIds;

    public List<String> getDbSecurityGroups() {
        return dbSecurityGroups;
    }

    public void setDbSecurityGroups(List<String> dbSecurityGroups) {
        this.dbSecurityGroups = dbSecurityGroups;
    }

    public String getMasterUserPassword() {
        return masterUserPassword;
    }

    public void setMasterUserPassword(String masterUserPassword) {
        this.masterUserPassword = masterUserPassword;
    }

    public List<String> getVpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    public void setVpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
        this.vpcSecurityGroupIds = vpcSecurityGroupIds;
    }
}
