/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.operation.group.security;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

public class SecurityParameterGroup {

    @Parameter
    @DisplayName("DB Subnet Group Name")
    @Placement(order = 3)
    @Optional
    private String dbSubnetGroupName;

    @Parameter
    @DisplayName("Domain IAM Role Name")
    @Placement(order = 4)
    @Optional
    private String domainIAMRoleName;

    @Parameter
    @DisplayName("Enable IAM Database Authentication")
    @Placement(order = 5)
    @Optional(defaultValue = "false")
    private boolean enableIAMDatabaseAuthentication;

    @Parameter
    @DisplayName("License Model")
    @Placement(order = 6)
    @Optional
    private String licenseModel;

    @Parameter
    @DisplayName("Publicly Accessible")
    @Placement(order = 8)
    @Optional(defaultValue = "false")
    private boolean publiclyAccessible;

    @Parameter
    @DisplayName("TDE Credential ARN")
    @Placement(order = 9)
    @Optional
    private String tdeCredentialArn;

    @Parameter
    @DisplayName("TDE Credential Password")
    @Placement(order = 10)
    @Optional
    private String tdeCredentialPassword;

    public String getDbSubnetGroupName() {
        return dbSubnetGroupName;
    }

    public void setDbSubnetGroupName(String dbSubnetGroupName) {
        this.dbSubnetGroupName = dbSubnetGroupName;
    }

    public String getDomainIAMRoleName() {
        return domainIAMRoleName;
    }

    public void setDomainIAMRoleName(String domainIAMRoleName) {
        this.domainIAMRoleName = domainIAMRoleName;
    }

    public boolean isEnableIAMDatabaseAuthentication() {
        return enableIAMDatabaseAuthentication;
    }

    public void setEnableIAMDatabaseAuthentication(boolean enableIAMDatabaseAuthentication) {
        this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
    }

    public String getLicenseModel() {
        return licenseModel;
    }

    public void setLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
    }

    public boolean isPubliclyAccessible() {
        return publiclyAccessible;
    }

    public void setPubliclyAccessible(boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
    }

    public String getTdeCredentialArn() {
        return tdeCredentialArn;
    }

    public void setTdeCredentialArn(String tdeCredentialArn) {
        this.tdeCredentialArn = tdeCredentialArn;
    }

    public String getTdeCredentialPassword() {
        return tdeCredentialPassword;
    }

    public void setTdeCredentialPassword(String tdeCredentialPassword) {
        this.tdeCredentialPassword = tdeCredentialPassword;
    }
}
