/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.operation.group.storage;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

public class AlterationStorageAndMaintenanceParameterGroup extends StorageParameterGroup {
    @Parameter
    @DisplayName("Allocated Storage")
    @Placement(order = 1)
    @Optional
    private Integer allocatedStorage;

    @Parameter
    @DisplayName("Backup Retention Period")
    @Placement(order = 5)
    @Optional
    private Integer backupRetentionPeriod;

    @Parameter
    @DisplayName("Preferred Backup Window")
    @Placement(order = 7)
    @Optional
    private String preferredBackupWindow;

    @Parameter
    @DisplayName("Preferred Maintenance Window")
    @Placement(order = 9)
    @Optional
    private String preferredMaintenanceWindow;

    @Parameter
    @DisplayName("Promotion Tier")
    @Placement(order = 10)
    @Optional
    private Integer promotionTier;

    public Integer getAllocatedStorage() {
        return allocatedStorage;
    }

    public void setAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
    }

    public Integer getBackupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    public void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.backupRetentionPeriod = backupRetentionPeriod;
    }

    public String getPreferredBackupWindow() {
        return preferredBackupWindow;
    }

    public void setPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
    }

    public String getPreferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public Integer getPromotionTier() {
        return promotionTier;
    }

    public void setPromotionTier(Integer promotionTier) {
        this.promotionTier = promotionTier;
    }
}
