/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.operation.group.storage;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

public class CreationStorageAndMaintenanceParameterGroup extends AlterationStorageAndMaintenanceParameterGroup {
    @Parameter
    @DisplayName("Storage Encrypted")
    @Placement(order = 9)
    @Optional(defaultValue = "false")
    boolean storageEncrypted;

    @Parameter
    @DisplayName("DB Cluster Identifier")
    @Placement(order = 5)
    @Optional
    private String dbClusterIdentifier;

    public String getDbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    public void setDbClusterIdentifier(String dbClusterIdentifier) {
        this.dbClusterIdentifier = dbClusterIdentifier;
    }

    public boolean isStorageEncrypted() {
        return storageEncrypted;
    }

    public void setStorageEncrypted(boolean storageEncrypted) {
        this.storageEncrypted = storageEncrypted;
    }
}
