/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.operation.group.storage;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

public class ModificationStorageAndMaintenanceParameterGroup extends AlterationStorageAndMaintenanceParameterGroup {

    @Parameter
    @DisplayName("Allow Major Version Upgrade")
    @Placement(order = 2)
    @Optional(defaultValue = "false")
    private boolean allowMajorVersionUpgrade;

    @Parameter
    @DisplayName("Apply Immediately")
    @Placement(order = 3)
    @Optional(defaultValue = "false")
    private boolean applyImmediately;

    public boolean isAllowMajorVersionUpgrade() {
        return allowMajorVersionUpgrade;
    }

    public void setAllowMajorVersionUpgrade(boolean allowMajorVersionUpgrade) {
        this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
    }

    public boolean isApplyImmediately() {
        return applyImmediately;
    }

    public void setApplyImmediately(boolean applyImmediately) {
        this.applyImmediately = applyImmediately;
    }
}
