/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.operation.group.storage;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

public class StorageParameterGroup {

    @Parameter
    @DisplayName("Auto Minor Version Upgrade")
    @Placement(order = 4)
    @Optional(defaultValue = "false")
    private boolean autoMinorVersionUpgrade;

    @Parameter
    @DisplayName("Copy Tags to Snapshot")
    @Placement(order = 6)
    @Optional(defaultValue = "false")
    private boolean copyTagsToSnapshot;

    @Parameter
    @DisplayName("Storage Type")
    @Placement(order = 11)
    @Optional
    private String storageType;

    public boolean isAutoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    public void setAutoMinorVersionUpgrade(boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public boolean isCopyTagsToSnapshot() {
        return copyTagsToSnapshot;
    }

    public void setCopyTagsToSnapshot(boolean copyTagsToSnapshot) {
        this.copyTagsToSnapshot = copyTagsToSnapshot;
    }

    public String getStorageType() {
        return storageType;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }
}
