/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.operation.paging;

import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.model.DescribeDBInstancesRequest;
import com.amazonaws.services.rds.model.DescribeDBInstancesResult;
import org.mule.extension.rds.api.model.DBInstance;
import org.mule.extension.rds.internal.util.RDSModelFactory;

public class DescribeDBInstancesPagingProvider extends RDSPagingProvider<DBInstance, com.amazonaws.services.rds.model.DBInstance, DescribeDBInstancesRequest, DescribeDBInstancesResult> {

    public DescribeDBInstancesPagingProvider(DescribeDBInstancesRequest request) {
        super(request,
                AmazonRDS::describeDBInstances,
                DescribeDBInstancesResult::getMarker,
                DescribeDBInstancesRequest::withMarker,
                DescribeDBInstancesResult::new,
                DescribeDBInstancesResult::getDBInstances,
                RDSModelFactory::wrapDBInstance);
    }
}