/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.operation.paging;

import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.model.DescribeDBSnapshotsRequest;
import com.amazonaws.services.rds.model.DescribeDBSnapshotsResult;
import org.mule.extension.rds.api.model.DBSnapshot;
import org.mule.extension.rds.internal.util.RDSModelFactory;

public class DescribeDBSnapshotsPagingProvider extends RDSPagingProvider<DBSnapshot, com.amazonaws.services.rds.model.DBSnapshot, DescribeDBSnapshotsRequest, DescribeDBSnapshotsResult> {

    public DescribeDBSnapshotsPagingProvider(DescribeDBSnapshotsRequest request) {
        super(request,
                AmazonRDS::describeDBSnapshots,
                DescribeDBSnapshotsResult::getMarker,
                DescribeDBSnapshotsRequest::withMarker,
                DescribeDBSnapshotsResult::new,
                DescribeDBSnapshotsResult::getDBSnapshots,
                RDSModelFactory::wrapDBSnapshot);
    }
}
