/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.operation.paging;

import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.model.DescribeEventsRequest;
import com.amazonaws.services.rds.model.DescribeEventsResult;
import org.mule.extension.rds.api.model.Event;
import org.mule.extension.rds.internal.util.RDSModelFactory;

public class DescribeEventsPagingProvider extends RDSPagingProvider<Event, com.amazonaws.services.rds.model.Event, DescribeEventsRequest, DescribeEventsResult> {

    public DescribeEventsPagingProvider(DescribeEventsRequest request) {
        super(request,
                AmazonRDS::describeEvents,
                DescribeEventsResult::getMarker,
                DescribeEventsRequest::withMarker,
                DescribeEventsResult::new,
                DescribeEventsResult::getEvents,
                RDSModelFactory::getEvent);
    }
}
