/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.operation.paging;

import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesRequest;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesResult;
import org.mule.extension.rds.api.model.ReservedDBInstance;
import org.mule.extension.rds.internal.util.RDSModelFactory;

public class DescribeReservedDBInstancesPagingProvider extends RDSPagingProvider<ReservedDBInstance, com.amazonaws.services.rds.model.ReservedDBInstance, DescribeReservedDBInstancesRequest, DescribeReservedDBInstancesResult> {

    public DescribeReservedDBInstancesPagingProvider(DescribeReservedDBInstancesRequest request) {
        super(request,
                AmazonRDS::describeReservedDBInstances,
                DescribeReservedDBInstancesResult::getMarker,
                DescribeReservedDBInstancesRequest::withMarker,
                DescribeReservedDBInstancesResult::new,
                DescribeReservedDBInstancesResult::getReservedDBInstances,
                RDSModelFactory::getReserverDBInstance);
    }
}