/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.operation.paging;

import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsRequest;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsResult;
import org.mule.extension.rds.api.model.ReservedDBInstancesOffering;
import org.mule.extension.rds.internal.util.RDSModelFactory;

public class DescribeReservedDbInstancesOfferingsPagingProvider extends RDSPagingProvider<ReservedDBInstancesOffering, com.amazonaws.services.rds.model.ReservedDBInstancesOffering, DescribeReservedDBInstancesOfferingsRequest, DescribeReservedDBInstancesOfferingsResult> {

    public DescribeReservedDbInstancesOfferingsPagingProvider(DescribeReservedDBInstancesOfferingsRequest request) {
        super(request,
                AmazonRDS::describeReservedDBInstancesOfferings,
                DescribeReservedDBInstancesOfferingsResult::getMarker,
                DescribeReservedDBInstancesOfferingsRequest::withMarker,
                DescribeReservedDBInstancesOfferingsResult::new,
                DescribeReservedDBInstancesOfferingsResult::getReservedDBInstancesOfferings,
                RDSModelFactory::getReservedDBInstancesOffering);
    }
}
