/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.service;

import org.mule.connectors.commons.template.service.ConnectorService;
import org.mule.extension.rds.api.model.DBInstance;
import org.mule.extension.rds.api.model.Tag;
import org.mule.extension.rds.internal.operation.group.MonitoringParameterGroup;
import org.mule.extension.rds.internal.operation.group.dbinstance.CreationDBInstanceParameterGroup;
import org.mule.extension.rds.internal.operation.group.dbinstance.ModificationDBInstanceParameterGroup;
import org.mule.extension.rds.internal.operation.group.security.CreationSecurityParameterGroup;
import org.mule.extension.rds.internal.operation.group.security.ModificationSecurityParameterGroup;
import org.mule.extension.rds.internal.operation.group.storage.CreationStorageAndMaintenanceParameterGroup;
import org.mule.extension.rds.internal.operation.group.storage.ModificationStorageAndMaintenanceParameterGroup;

import java.time.LocalDateTime;
import java.util.Collection;

public interface DBInstanceService extends ConnectorService {
    DBInstance createDbInstance(CreationStorageAndMaintenanceParameterGroup storageAndMaintenanceParameterGroup,
                                CreationSecurityParameterGroup securityParameterGroup,
                                MonitoringParameterGroup monitoringParameterGroup,
                                CreationDBInstanceParameterGroup dbInstanceParameterGroup);

    DBInstance modifyDbInstance(ModificationStorageAndMaintenanceParameterGroup storageAndMaintenanceParameterGroup,
                                ModificationSecurityParameterGroup securityParameterGroup,
                                MonitoringParameterGroup monitoringParameterGroup,
                                ModificationDBInstanceParameterGroup dbInstanceParameterGroup);

    DBInstance deleteDBInstance(String dBInstanceIdentifier,
                                String finalDBSnapshotIdentifier,
                                Boolean skipFinalSnapshot);

    DBInstance startDBInstance(String dBInstanceIdentifier);

    DBInstance stopDBInstance(String dBInstanceIdentifier,
                              String dBSnapshotIdentifier);

    DBInstance rebootDBInstance(String dBInstanceIdentifier,
                                Boolean forceFailover);

    DBInstance restoreDbInstanceToPointInTime(boolean autoMinorVersionUpgrade,
                                              String availabilityZone,
                                              boolean copyTagsToSnapshot,
                                              String dBInstanceClass,
                                              String dBName,
                                              String dBSubnetGroupName,
                                              String domain,
                                              String domainIAMRoleName,
                                              boolean enableIAMDatabaseAuthentication,
                                              String engine,
                                              Integer iops,
                                              String licenseModel,
                                              boolean multiAZ,
                                              String optionGroupName,
                                              Integer port,
                                              boolean publiclyAccessible,
                                              LocalDateTime restoreTime,
                                              String sourceDBInstanceIdentifier,
                                              String storageType,
                                              Collection<Tag> tags,
                                              String targetDBInstanceIdentifier,
                                              String tdeCredentialArn,
                                              String tdeCredentialPassword,
                                              boolean useLatestRestorableTime);
}
