/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.service;

import com.amazonaws.services.rds.model.CreateDBSnapshotRequest;
import com.amazonaws.services.rds.model.DeleteDBSnapshotRequest;
import com.amazonaws.services.rds.model.ModifyDBSnapshotRequest;
import org.mule.extension.rds.api.model.DBSnapshot;
import org.mule.extension.rds.api.model.Tag;
import org.mule.extension.rds.internal.config.RDSConfiguration;
import org.mule.extension.rds.internal.connection.RDSConnection;
import org.mule.extension.rds.internal.util.RDSModelFactory;

import java.util.List;
import java.util.Optional;

public class DBSnapshotServiceImpl extends RDSServiceImpl implements DBSnapshotService {

    public DBSnapshotServiceImpl(RDSConfiguration config, RDSConnection connection) {
        super(config, connection);
    }

    @Override
    public DBSnapshot createDBSnapshot(String dBInstanceIdentifier,
                                       String dBSnapshotIdentifier,
                                       List<Tag> tags) {
        return RDSModelFactory.wrapDBSnapshot(getConnection().getAwsClient().createDBSnapshot(new CreateDBSnapshotRequest()
                .withDBInstanceIdentifier(dBInstanceIdentifier)
                .withDBSnapshotIdentifier(dBSnapshotIdentifier)
                .withTags(Optional.ofNullable(tags).map(RDSModelFactory::wrapTagList).orElse(null))));
    }

    @Override
    public DBSnapshot deleteDBSnapshot(String dBSnapshotIdentifier) {
        return RDSModelFactory.wrapDBSnapshot(getConnection().getAwsClient().deleteDBSnapshot(new DeleteDBSnapshotRequest()
                .withDBSnapshotIdentifier(dBSnapshotIdentifier)));
    }

    @Override
    public DBSnapshot modifyDBSnapshot(String dBSnapshotIdentifier, String engineVersion) {
        return RDSModelFactory.wrapDBSnapshot(getConnection().getAwsClient().modifyDBSnapshot(new ModifyDBSnapshotRequest()
                .withDBSnapshotIdentifier(dBSnapshotIdentifier)
                .withEngineVersion(engineVersion)));
    }
}
