/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.service;


import com.amazonaws.services.rds.AmazonRDS;
import org.mule.connectors.commons.template.service.ConnectorService;
import org.mule.connectors.commons.template.service.DefaultConnectorService;
import org.mule.extension.rds.internal.config.RDSConfiguration;
import org.mule.extension.rds.internal.connection.RDSConnection;

public class RDSServiceImpl extends DefaultConnectorService<RDSConfiguration, RDSConnection> implements ConnectorService {

    public RDSServiceImpl(RDSConfiguration config, RDSConnection connection) {
        super(config, connection);
    }

    protected AmazonRDS getAwsClient() {
        return getConnection().getAwsClient();
    }
}
