/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.service;


import com.amazonaws.services.rds.model.PurchaseReservedDBInstancesOfferingRequest;
import org.mule.extension.rds.api.model.ReservedDBInstance;
import org.mule.extension.rds.api.model.Tag;
import org.mule.extension.rds.internal.config.RDSConfiguration;
import org.mule.extension.rds.internal.connection.RDSConnection;
import org.mule.extension.rds.internal.util.RDSModelFactory;

import java.util.List;

public class ReservedDBInstanceServiceImpl extends RDSServiceImpl implements ReservedDBInstanceService {

    public ReservedDBInstanceServiceImpl(RDSConfiguration config, RDSConnection connection) {
        super(config, connection);
    }


    public ReservedDBInstance purchaseReservedDBInstancesOffering(String reservedDBInstancesOfferingId,
                                                                  Integer dBInstanceCount,
                                                                  String reservedDBInstanceId,
                                                                  List<Tag> tags) {
        return RDSModelFactory.wrapPurchaseReservedDBInstancesOffering(getConnection().getAwsClient().purchaseReservedDBInstancesOffering(new PurchaseReservedDBInstancesOfferingRequest()
                .withReservedDBInstancesOfferingId(reservedDBInstancesOfferingId)
                .withDBInstanceCount(dBInstanceCount)
                .withReservedDBInstanceId(reservedDBInstanceId)
                .withTags(RDSModelFactory.wrapTagList(tags))));
    }
}
