/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Optional;

import static java.time.ZoneId.systemDefault;

public final class DateUtils {
    private DateUtils() {
        // Do nothing.
    }

    public static LocalDate toLocalDate(Date date) {
        return toLocalDate(date, systemDefault());
    }

    public static LocalDate toLocalDate(Date date, ZoneId zoneId) {
        return Optional.ofNullable(date).map(value -> toZonedDateTime(date, zoneId).toLocalDate()).orElse(null);
    }

    public static LocalTime toLocalTime(Date date) {
        return toLocalTime(date, systemDefault());
    }

    public static LocalTime toLocalTime(Date date, ZoneId zoneId) {
        return Optional.ofNullable(date).map(value -> toZonedDateTime(date, zoneId).toLocalTime()).orElse(null);
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return toLocalDateTime(date, systemDefault());
    }

    public static LocalDateTime toLocalDateTime(Date date, ZoneId zoneId) {
        return Optional.ofNullable(date).map(value -> toZonedDateTime(date, zoneId).toLocalDateTime()).orElse(null);
    }

    public static ZonedDateTime toZonedDateTime(Date date, ZoneId zoneId) {
        return date.toInstant().atZone(zoneId);
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return Optional.ofNullable(localDateTime)
                .map(value -> value.atZone(systemDefault()))
                .map(ZonedDateTime::toInstant)
                .map(Date::from)
                .orElse(null);
    }
}
