/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.util;


import org.dozer.DozerBeanMapper;
import org.dozer.Mapper;

import java.util.ArrayList;
import java.util.List;

public class DozerBeanMapperSingletonWrapper {

    private static Mapper instance;

    private static List<String> mappingFiles = new ArrayList<String>();
    ;

    private DozerBeanMapperSingletonWrapper() {
    }

    private static void addMappingFiles() {
        mappingFiles.add("dozer-mapping-rds.xml");
    }

    public static synchronized Mapper getInstance() {
        if (instance == null) {
            mappingFiles.clear();
            addMappingFiles();
            instance = new DozerBeanMapper(mappingFiles);
        }
        return instance;
    }
}
