/**
 * (c) 2003-2019 MuleSoft, Inc. The software in this package is
 * published under the terms of the Commercial Free Software license V.1, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.extension.rds.internal.util;


import org.dozer.Mapper;
import org.mule.extension.rds.api.model.DBInstance;
import org.mule.extension.rds.api.model.DBSnapshot;
import org.mule.extension.rds.api.model.Event;
import org.mule.extension.rds.api.model.Filter;
import org.mule.extension.rds.api.model.ReservedDBInstance;
import org.mule.extension.rds.api.model.ReservedDBInstancesOffering;
import org.mule.extension.rds.api.model.Tag;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class RDSModelFactory {

    private static final Mapper mapper = DozerBeanMapperSingletonWrapper.getInstance();


    private RDSModelFactory() {
    }

    public static List<com.amazonaws.services.rds.model.Tag> wrapTagList(Collection<Tag> sourceTags) {

        List<com.amazonaws.services.rds.model.Tag> targetTags = new ArrayList<com.amazonaws.services.rds.model.Tag>();

        if (sourceTags != null) {

            for (Tag sourceTag : sourceTags) {
                com.amazonaws.services.rds.model.Tag targetTag = new com.amazonaws.services.rds.model.Tag();
                targetTag.setKey(sourceTag.getKey());
                targetTag.setValue(sourceTag.getValue());

                targetTags.add(targetTag);
            }
        }

        return targetTags;
    }

    public static List<com.amazonaws.services.rds.model.Filter> unWrapFilterList(Collection<Filter> sourceFilters) {

        List<com.amazonaws.services.rds.model.Filter> targetFilters = null;

        if (sourceFilters != null) {
            targetFilters = new ArrayList<com.amazonaws.services.rds.model.Filter>();

            for (Filter sourceFilter : sourceFilters) {
                targetFilters.add(unWrapFilter(sourceFilter));
            }
        }

        return targetFilters;
    }

    public static com.amazonaws.services.rds.model.Filter unWrapFilter(Filter sourceFilter) {
        com.amazonaws.services.rds.model.Filter targetFilter = null;

        if (sourceFilter != null) {
            targetFilter = new com.amazonaws.services.rds.model.Filter();
            targetFilter.setName(sourceFilter.getName());
            targetFilter.setValues(sourceFilter.getValues());
        }

        return targetFilter;
    }


    public static DBInstance wrapDBInstance(final com.amazonaws.services.rds.model.DBInstance sourceDBInstance) {
        return getDBInstanceWithLocalDateTime(sourceDBInstance);
    }


    public static DBSnapshot wrapDBSnapshot(final com.amazonaws.services.rds.model.DBSnapshot sourceDBSnapshot) {
        return getDBSnapshotWithLocalDateTime(sourceDBSnapshot);
    }

    public static DBInstance wrapCreateDBInstanceReadReplica(final com.amazonaws.services.rds.model.DBInstance sourceDBInstance) {
        return getDBInstanceWithLocalDateTime(sourceDBInstance);
    }

    public static ReservedDBInstancesOffering getReservedDBInstancesOffering(final com.amazonaws.services.rds.model.ReservedDBInstancesOffering sourceReservedDBInstancesOffering) {
        return mapper.map(sourceReservedDBInstancesOffering, ReservedDBInstancesOffering.class);
    }

    public static Event getEvent(final com.amazonaws.services.rds.model.Event sourceEvent) {
        Date dateValue = sourceEvent.getDate();
        Event event = mapper.map(sourceEvent, Event.class);
        event.setDate(DateUtils.toLocalDateTime(dateValue));
        return event;
    }


    public static ReservedDBInstance wrapPurchaseReservedDBInstancesOffering(final com.amazonaws.services.rds.model.ReservedDBInstance source) {
        return getReservedDBInstanceWithLocalDateTime(source);
    }

    public static DBInstance getDBInstanceWithLocalDateTime(final com.amazonaws.services.rds.model.DBInstance sourceDBInstance) {
        Date instanceCreateTime = sourceDBInstance.getInstanceCreateTime();
        Date lastrestorableTime = sourceDBInstance.getLatestRestorableTime();
        DBInstance dbInstance = mapper.map(sourceDBInstance, DBInstance.class);
        dbInstance.setInstanceCreateTime(DateUtils.toLocalDateTime(instanceCreateTime));
        dbInstance.setLatestRestorableTime(DateUtils.toLocalDateTime(lastrestorableTime));
        return dbInstance;
    }

    public static DBSnapshot getDBSnapshotWithLocalDateTime(final com.amazonaws.services.rds.model.DBSnapshot sourceDBSnapshot) {
        Date instanceCreateTime = sourceDBSnapshot.getInstanceCreateTime();
        Date snapshotCreateTime = sourceDBSnapshot.getSnapshotCreateTime();
        DBSnapshot dbSnapshot = mapper.map(sourceDBSnapshot, DBSnapshot.class);
        dbSnapshot.setInstanceCreateTime(DateUtils.toLocalDateTime(instanceCreateTime));
        dbSnapshot.setSnapshotCreateTime(DateUtils.toLocalDateTime(snapshotCreateTime));
        return dbSnapshot;
    }

    public static ReservedDBInstance getReserverDBInstance(final com.amazonaws.services.rds.model.ReservedDBInstance sourceReservedDBInstance) {
        return getReservedDBInstanceWithLocalDateTime(sourceReservedDBInstance);
    }

    public static ReservedDBInstance getReservedDBInstanceWithLocalDateTime(final com.amazonaws.services.rds.model.ReservedDBInstance sourceReservedDBInstance) {
        ReservedDBInstance reservedDBInstance = null;
        if (sourceReservedDBInstance != null) {
            Date startTime = sourceReservedDBInstance.getStartTime();
            reservedDBInstance = mapper.map(sourceReservedDBInstance, ReservedDBInstance.class);
            reservedDBInstance.setStartTime(DateUtils.toLocalDateTime(startTime));
        }
        return reservedDBInstance;
    }
}