/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.s3.api.attributes;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.mule.extension.s3.api.group.ObjectMetadataParameterGroup;
import org.mule.extension.s3.api.model.StorageClass;

public class S3ObjectAttributes
implements Serializable {
    private String key;
    private String bucketName;
    private boolean requesterCharged;
    private String redirectLocation;
    private ObjectMetadataParameterGroup delegate;
    private Long contentLength;

    public S3ObjectAttributes() {
    }

    public S3ObjectAttributes(String key, String bucketName, String redirectLocation, boolean requesterCharged, ObjectMetadataParameterGroup delegate) {
        this.key = key;
        this.bucketName = bucketName;
        this.redirectLocation = redirectLocation;
        this.requesterCharged = requesterCharged;
        this.delegate = delegate;
        this.contentLength = Optional.ofNullable(delegate.getContentLength()).orElse(null);
    }

    public String getKey() {
        return this.key;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getVersionId() {
        return this.delegate.getVersionId();
    }

    public String getExpirationTimeRuleId() {
        return this.delegate.getExpirationTimeRuleId();
    }

    public String getEtag() {
        return this.delegate.getEtag();
    }

    public String getContentType() {
        return this.delegate.getContentType();
    }

    public String getContentMD5() {
        return this.delegate.getContentMD5();
    }

    public String getContentEncoding() {
        return this.delegate.getContentEncoding();
    }

    public String getContentDisposition() {
        return this.delegate.getContentDisposition();
    }

    public String getCacheControl() {
        return this.delegate.getCacheControl();
    }

    public Map<String, String> getUserMetadata() {
        return this.delegate.getUserMetadata();
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public LocalDateTime getRestoreExpirationTime() {
        return this.delegate.getRestoreExpirationTime();
    }

    public LocalDateTime getLastModified() {
        return this.delegate.getLastModified();
    }

    public LocalDateTime getHttpExpiresDate() {
        return this.delegate.getHttpExpiresDate();
    }

    public LocalDateTime getExpirationTime() {
        return this.delegate.getExpirationTime();
    }

    public StorageClass getStorageClass() {
        return this.delegate.getStorageClass();
    }

    public String getContentLanguage() {
        return this.delegate.getContentLanguage();
    }

    public String getReplicationStatus() {
        return this.delegate.getReplicationStatus();
    }

    public String getSseAlgorithm() {
        return this.delegate.getSseAlgorithm();
    }

    public String getSseAwsKmsKeyId() {
        return this.delegate.getSseAwsKmsKeyId();
    }

    public String getSseCustomerAlgorithm() {
        return this.delegate.getSseCustomerAlgorithm();
    }

    public String getSseCustomerKeyMd5() {
        return this.delegate.getSseCustomerKeyMd5();
    }

    public boolean isOngoingRestore() {
        return this.delegate.isOngoingRestore();
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public boolean isRequesterCharged() {
        return this.requesterCharged;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3ObjectAttributes that = (S3ObjectAttributes)o;
        return this.requesterCharged == that.requesterCharged && Objects.equals(this.key, that.key) && Objects.equals(this.bucketName, that.bucketName) && Objects.equals(this.redirectLocation, that.redirectLocation) && Objects.equals(this.delegate, that.delegate) && Objects.equals(this.contentLength, that.contentLength);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.bucketName, this.requesterCharged, this.redirectLocation, this.delegate, this.contentLength);
    }
}

