/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.s3.api.model;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;
import org.mule.extension.s3.api.model.Owner;

public class S3ObjectSummary
implements Serializable {
    private static final long serialVersionUID = 4983096516451498237L;
    protected String bucketName;
    protected String key;
    protected String eTag;
    protected long size;
    protected LocalDateTime lastModified;
    protected String storageClass;
    protected Owner owner;

    public S3ObjectSummary() {
    }

    public S3ObjectSummary(String bucketName, String key, String eTag, long size, LocalDateTime lastModified, String storageClass, Owner owner) {
        this.bucketName = bucketName;
        this.key = key;
        this.eTag = eTag;
        this.size = size;
        this.lastModified = lastModified;
        this.storageClass = storageClass;
        this.owner = owner;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getKey() {
        return this.key;
    }

    public String getETag() {
        return this.eTag;
    }

    public long getSize() {
        return this.size;
    }

    public LocalDateTime getLastModified() {
        return this.lastModified;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3ObjectSummary that = (S3ObjectSummary)o;
        return this.size == that.size && Objects.equals(this.bucketName, that.bucketName) && Objects.equals(this.key, that.key) && Objects.equals(this.eTag, that.eTag) && Objects.equals(this.lastModified, that.lastModified) && Objects.equals(this.storageClass, that.storageClass) && Objects.equals(this.owner, that.owner);
    }

    public int hashCode() {
        return Objects.hash(this.bucketName, this.key, this.eTag, this.size, this.lastModified, this.storageClass, this.owner);
    }
}

