/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.s3.internal.config.group;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class AdditionalParameterGroup {
    @Parameter
    @DisplayName(value="Force Global Bucket Access")
    @Optional(defaultValue="false")
    @Placement(order=1, tab="Advanced")
    @Summary(value="Any bucket-related operations invoked against a client with this option enabled will potentially be executed against other regions than the one configured in the client in order to succeed.")
    private boolean forceGlobalBucketAccess;
    @Parameter
    @Deprecated
    @DisplayName(value="S3 Compatible Storage URL (Deprecated)")
    @Optional
    @Placement(order=2, tab="Advanced")
    @Summary(value="(If both the Custom Service Endpoint and Storage Url are specified, then the Custom Service Endpoint is used.) The URL to connect to when S3-compatible storage is used. If blank, the connector uses the default AWS S3 URL.")
    @Example(value="https://s3.us-east-1.amazonaws.com")
    private String storageUrl;

    public AdditionalParameterGroup() {
    }

    public AdditionalParameterGroup(String storageUrl, boolean forceGlobalBucketAccess) {
        this.storageUrl = storageUrl;
        this.forceGlobalBucketAccess = forceGlobalBucketAccess;
    }

    public boolean isForceGlobalBucketAccess() {
        return this.forceGlobalBucketAccess;
    }

    public String getStorageUrl() {
        return this.storageUrl;
    }
}

