/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.s3.internal.operation;

import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.services.s3.model.BucketWebsiteConfiguration;
import com.amazonaws.services.s3.model.CORSRule;
import com.amazonaws.services.s3.model.CanonicalGrantee;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.EmailAddressGrantee;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.GroupGrantee;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.PartSummary;
import com.amazonaws.services.s3.model.RedirectRule;
import com.amazonaws.services.s3.model.RoutingRule;
import com.amazonaws.services.s3.model.StorageClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.extension.s3.api.attributes.AccessControlListAttributes;
import org.mule.extension.s3.api.model.AllowedMethods;
import org.mule.extension.s3.api.model.BLCRule;
import org.mule.extension.s3.api.model.Bucket;
import org.mule.extension.s3.api.model.CORSRule;
import org.mule.extension.s3.api.model.CopyPartResult;
import org.mule.extension.s3.api.model.Grant;
import org.mule.extension.s3.api.model.GranteeType;
import org.mule.extension.s3.api.model.GroupUri;
import org.mule.extension.s3.api.model.MultipartUpload;
import org.mule.extension.s3.api.model.NoncurrentVersionTransition;
import org.mule.extension.s3.api.model.Owner;
import org.mule.extension.s3.api.model.PartListing;
import org.mule.extension.s3.api.model.Permission;
import org.mule.extension.s3.api.model.RoutingRuleCondition;
import org.mule.extension.s3.api.model.S3ObjectSummary;
import org.mule.extension.s3.api.model.S3VersionSummary;
import org.mule.extension.s3.api.model.TopicConfiguration;
import org.mule.extension.s3.api.model.Transition;
import org.mule.extension.s3.api.model.UploadPartResult;
import org.mule.extension.s3.internal.util.DateUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;

@Deprecated
public class S3ModelFactory {
    private S3ModelFactory() {
    }

    public static Bucket wrapBucket(com.amazonaws.services.s3.model.Bucket bucket) {
        return new Bucket(bucket.getName(), Optional.ofNullable(bucket.getOwner()).map(o -> new Owner(o.getId(), o.getDisplayName())).orElseGet(Owner::new), DateUtils.toLocalDateTime(bucket.getCreationDate()));
    }

    public static AccessControlList unwrapAccessControlList(Owner owner, List<Grant> grants) {
        AccessControlList accessControlList = new AccessControlList();
        if (owner != null) {
            accessControlList.setOwner(new com.amazonaws.services.s3.model.Owner(owner.getId(), owner.getDisplayName()));
        }
        if (grants != null) {
            for (Grant grant : grants) {
                GroupGrantee grantee;
                switch (grant.getGrantee().getTypeIdentifier()) {
                    case ID: {
                        CanonicalGrantee canonicalGrantee = new CanonicalGrantee(grant.getGrantee().getIdentifier());
                        canonicalGrantee.setDisplayName(grant.getGrantee().getDisplayName());
                        grantee = canonicalGrantee;
                        break;
                    }
                    case EMAIL_ADDRESS: {
                        grantee = new EmailAddressGrantee(grant.getGrantee().getIdentifier());
                        break;
                    }
                    default: {
                        grantee = GroupGrantee.parseGroupGrantee((String)grant.getGrantee().getGroupUri().getGroupUri());
                    }
                }
                accessControlList.grantPermission((Grantee)grantee, com.amazonaws.services.s3.model.Permission.parsePermission((String)grant.getPermission().toString()));
            }
        }
        return accessControlList;
    }

    private static org.mule.extension.s3.api.model.Grantee createGrantee(Grantee grantee) {
        switch (grantee.getTypeIdentifier()) {
            case "id": {
                return new org.mule.extension.s3.api.model.Grantee(GranteeType.ID, null, grantee.getIdentifier(), ((CanonicalGrantee)CanonicalGrantee.class.cast(grantee)).getDisplayName());
            }
            case "emailAddress": {
                return new org.mule.extension.s3.api.model.Grantee(GranteeType.EMAIL_ADDRESS, null, grantee.getIdentifier(), null);
            }
            case "uri": {
                return new org.mule.extension.s3.api.model.Grantee(GranteeType.URI, GroupUri.valueOf(((GroupGrantee)GroupGrantee.class.cast(grantee)).name()), grantee.getIdentifier(), null);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Result<List<Grant>, AccessControlListAttributes> wrapAccessControlList(AccessControlList objectAcl) {
        Result.Builder builder = Result.builder();
        if (objectAcl.getOwner() != null) {
            Owner owner = new Owner(objectAcl.getOwner().getId(), objectAcl.getOwner().getDisplayName());
            builder.attributes((Object)new AccessControlListAttributes(owner));
        }
        return builder.output((Object)Optional.ofNullable(objectAcl.getGrantsAsList()).map(g -> g.stream().map(grant -> new Grant(S3ModelFactory.createGrantee(grant.getGrantee()), Permission.valueOf(grant.getPermission().toString()))).collect(Collectors.toList())).orElseGet(ArrayList::new)).build();
    }

    public static List<CORSRule> wrapBucketCrossOriginConfigurationRules(List<com.amazonaws.services.s3.model.CORSRule> rules) {
        return rules.stream().map(rule -> new CORSRule(rule.getId(), Optional.ofNullable(rule.getAllowedMethods()).map(m -> m.stream().map(am -> AllowedMethods.valueOf(am.name())).collect(Collectors.toList())).orElseGet(ArrayList::new), rule.getAllowedOrigins(), rule.getMaxAgeSeconds(), rule.getExposedHeaders(), rule.getAllowedHeaders())).collect(Collectors.toList());
    }

    public static List<com.amazonaws.services.s3.model.CORSRule> unwrapBucketCrossOriginConfigurationRules(List<CORSRule> crossOriginConfigurationRules) {
        ArrayList<com.amazonaws.services.s3.model.CORSRule> corsRules = new ArrayList<com.amazonaws.services.s3.model.CORSRule>(crossOriginConfigurationRules.size());
        for (CORSRule rule : crossOriginConfigurationRules) {
            com.amazonaws.services.s3.model.CORSRule corsRule = new com.amazonaws.services.s3.model.CORSRule();
            corsRule.setId(rule.getId());
            corsRule.setMaxAgeSeconds(rule.getMaxAgeSeconds());
            corsRule.setAllowedHeaders(rule.getAllowedHeaders());
            corsRule.setAllowedOrigins(rule.getAllowedOrigins());
            corsRule.setExposedHeaders(rule.getExposedHeaders());
            if (rule.getAllowedMethods() != null) {
                ArrayList<CORSRule.AllowedMethods> allowedMethods = new ArrayList<CORSRule.AllowedMethods>(rule.getAllowedMethods().size());
                for (AllowedMethods allowedMethod : rule.getAllowedMethods()) {
                    allowedMethods.add(CORSRule.AllowedMethods.fromValue((String)allowedMethod.name()));
                }
                corsRule.setAllowedMethods(allowedMethods);
            }
            corsRules.add(corsRule);
        }
        return corsRules;
    }

    public static List<BLCRule> wrapBucketLifecycleRules(List<BucketLifecycleConfiguration.Rule> rules) {
        return rules.stream().map(rule -> new BLCRule(rule.getId(), rule.getPrefix(), rule.getStatus(), rule.getExpirationInDays(), rule.getNoncurrentVersionExpirationInDays(), DateUtils.toLocalDateTime(rule.getExpirationDate()), Optional.ofNullable(rule.getTransition()).map(S3ModelFactory::transform).orElse(null), Optional.ofNullable(rule.getNoncurrentVersionTransition()).map(S3ModelFactory::transform).orElse(null))).collect(Collectors.toList());
    }

    private static NoncurrentVersionTransition transform(BucketLifecycleConfiguration.NoncurrentVersionTransition noncurrentVersionTransition) {
        return new NoncurrentVersionTransition(noncurrentVersionTransition.getDays(), org.mule.extension.s3.api.model.StorageClass.valueOf(noncurrentVersionTransition.getStorageClass().toString()));
    }

    private static Transition transform(BucketLifecycleConfiguration.Transition transition) {
        return new Transition(transition.getDays(), DateUtils.toLocalDateTime(transition.getDate()), org.mule.extension.s3.api.model.StorageClass.valueOf(transition.getStorageClass().toString()));
    }

    public static List<BucketLifecycleConfiguration.Rule> unwrapBucketLifecycleConfigurationRules(List<BLCRule> lifecycleConfigurationRules) {
        ArrayList<BucketLifecycleConfiguration.Rule> blcRules = new ArrayList<BucketLifecycleConfiguration.Rule>(lifecycleConfigurationRules.size());
        for (BLCRule rule : lifecycleConfigurationRules) {
            NoncurrentVersionTransition noncurrentVersionTransition;
            BucketLifecycleConfiguration.Rule blcRule = new BucketLifecycleConfiguration.Rule();
            blcRule.setId(rule.getId());
            blcRule.setPrefix(rule.getPrefix());
            blcRule.setStatus(rule.getStatus());
            blcRule.setExpirationDate(DateUtils.toDate(rule.getExpirationDate()));
            blcRule.setExpirationInDays(rule.getExpirationInDays());
            blcRule.setNoncurrentVersionExpirationInDays(rule.getNoncurrentVersionExpirationInDays());
            Transition transition = rule.getTransition();
            if (transition != null) {
                BucketLifecycleConfiguration.Transition newTransition = new BucketLifecycleConfiguration.Transition();
                newTransition.setDate(DateUtils.toDate(transition.getDate()));
                newTransition.setDays(transition.getDays());
                newTransition.setStorageClass(StorageClass.fromValue((String)transition.getStorageClass().toString()));
                blcRule.setTransition(newTransition);
            }
            if ((noncurrentVersionTransition = rule.getNoncurrentVersionTransition()) != null) {
                BucketLifecycleConfiguration.NoncurrentVersionTransition versionTransition = new BucketLifecycleConfiguration.NoncurrentVersionTransition();
                versionTransition.setDays(noncurrentVersionTransition.getDays());
                versionTransition.setStorageClass(StorageClass.fromValue((String)noncurrentVersionTransition.getStorageClass().toString()));
                blcRule.setNoncurrentVersionTransition(versionTransition);
            }
            blcRules.add(blcRule);
        }
        return blcRules;
    }

    public static BucketWebsiteConfiguration unwrapBucketWebsiteConfiguration(org.mule.extension.s3.api.model.BucketWebsiteConfiguration configuration) {
        List<org.mule.extension.s3.api.model.RoutingRule> routingRules;
        BucketWebsiteConfiguration newConfiguration = new BucketWebsiteConfiguration(configuration.getIndexDocumentSuffix(), configuration.getErrorDocument());
        org.mule.extension.s3.api.model.RedirectRule redirectRule = configuration.getRedirectAllRequestsTo();
        if (redirectRule != null) {
            RedirectRule newRedirectRule = new RedirectRule().withHostName(redirectRule.getHostName()).withProtocol(redirectRule.getProtocol()).withReplaceKeyPrefixWith(redirectRule.getReplaceKeyPrefixWith()).withReplaceKeyWith(redirectRule.getReplaceKeyWith()).withHttpRedirectCode(redirectRule.getHttpRedirectCode());
            newConfiguration.setRedirectAllRequestsTo(newRedirectRule);
        }
        if (!(routingRules = configuration.getRoutingRules()).isEmpty()) {
            ArrayList<RoutingRule> newRoutingRules = new ArrayList<RoutingRule>(routingRules.size());
            for (org.mule.extension.s3.api.model.RoutingRule routingRule : routingRules) {
                com.amazonaws.services.s3.model.RoutingRuleCondition ruleCondition = null;
                RoutingRuleCondition condition = routingRule.getCondition();
                if (condition != null) {
                    ruleCondition = new com.amazonaws.services.s3.model.RoutingRuleCondition().withHttpErrorCodeReturnedEquals(condition.getHttpErrorCodeReturnedEquals()).withKeyPrefixEquals(condition.getKeyPrefixEquals());
                }
                RedirectRule rule = null;
                org.mule.extension.s3.api.model.RedirectRule ruleRedirect = routingRule.getRedirect();
                if (ruleRedirect != null) {
                    rule = new RedirectRule().withHostName(ruleRedirect.getHostName()).withProtocol(ruleRedirect.getProtocol()).withHttpRedirectCode(ruleRedirect.getHttpRedirectCode()).withReplaceKeyPrefixWith(ruleRedirect.getReplaceKeyPrefixWith()).withReplaceKeyWith(ruleRedirect.getReplaceKeyWith());
                }
                newRoutingRules.add(new RoutingRule().withCondition(ruleCondition).withRedirect(rule));
            }
            newConfiguration.setRoutingRules(newRoutingRules);
        }
        return newConfiguration;
    }

    private static org.mule.extension.s3.api.model.RedirectRule createRedirectRule(RedirectRule redirectRule) {
        return new org.mule.extension.s3.api.model.RedirectRule(redirectRule.getprotocol(), redirectRule.getHostName(), redirectRule.getReplaceKeyPrefixWith(), redirectRule.getReplaceKeyWith(), redirectRule.getHttpRedirectCode());
    }

    private static List<org.mule.extension.s3.api.model.RoutingRule> createRoutingRules(List<RoutingRule> routingRules) {
        return routingRules.stream().map(r -> new org.mule.extension.s3.api.model.RoutingRule(Optional.ofNullable(r.getCondition()).map(c -> new RoutingRuleCondition(c.getKeyPrefixEquals(), c.getHttpErrorCodeReturnedEquals())).orElse(null), Optional.ofNullable(r.getRedirect()).map(S3ModelFactory::createRedirectRule).orElse(null))).collect(Collectors.toList());
    }

    public static org.mule.extension.s3.api.model.BucketWebsiteConfiguration wrapBucketWebsiteConfiguration(BucketWebsiteConfiguration configuration) {
        return Optional.ofNullable(configuration).map(c -> new org.mule.extension.s3.api.model.BucketWebsiteConfiguration(c.getIndexDocumentSuffix(), c.getErrorDocument(), Optional.ofNullable(configuration.getRedirectAllRequestsTo()).map(S3ModelFactory::createRedirectRule).orElse(null), Optional.ofNullable(configuration.getRoutingRules()).map(S3ModelFactory::createRoutingRules).orElse(null))).orElseGet(org.mule.extension.s3.api.model.BucketWebsiteConfiguration::new);
    }

    public static Map<String, TopicConfiguration> wrapBucketNotification(BucketNotificationConfiguration configuration) {
        HashMap<String, TopicConfiguration> configurationMap = new HashMap<String, TopicConfiguration>();
        if (configuration != null) {
            configuration.getConfigurations().forEach((key, value) -> {
                if (value instanceof com.amazonaws.services.s3.model.TopicConfiguration) {
                    com.amazonaws.services.s3.model.TopicConfiguration entryValue = (com.amazonaws.services.s3.model.TopicConfiguration)com.amazonaws.services.s3.model.TopicConfiguration.class.cast(value);
                    configurationMap.put((String)key, S3ModelFactory.transform(entryValue));
                }
            });
        }
        return configurationMap;
    }

    private static TopicConfiguration transform(com.amazonaws.services.s3.model.TopicConfiguration topicConfiguration) {
        return new TopicConfiguration(topicConfiguration.getTopicARN(), topicConfiguration.getEvents(), topicConfiguration.getObjectPrefixes());
    }

    public static BucketNotificationConfiguration unwrapBucketNotification(Map<String, TopicConfiguration> notificationConfigurations) {
        BucketNotificationConfiguration bucketConfiguration = new BucketNotificationConfiguration();
        HashMap<String, com.amazonaws.services.s3.model.TopicConfiguration> configurations = new HashMap<String, com.amazonaws.services.s3.model.TopicConfiguration>();
        for (Map.Entry<String, TopicConfiguration> entry : notificationConfigurations.entrySet()) {
            com.amazonaws.services.s3.model.TopicConfiguration topicConfiguration = new com.amazonaws.services.s3.model.TopicConfiguration(entry.getValue().getTopicARN(), new String[0]);
            topicConfiguration.setEvents(entry.getValue().getEvents());
            topicConfiguration.setObjectPrefixes(entry.getValue().getObjectPrefixes());
            configurations.put(entry.getKey(), topicConfiguration);
        }
        return bucketConfiguration.withNotificationConfiguration(configurations);
    }

    public static UploadPartResult wrapUploadPartResult(com.amazonaws.services.s3.model.UploadPartResult partResult) {
        return Optional.ofNullable(partResult).map(r -> new UploadPartResult(r.getPartNumber(), r.getETag())).orElseGet(UploadPartResult::new);
    }

    public static CopyPartResult wrapCopyPartResult(com.amazonaws.services.s3.model.CopyPartResult partResult) {
        return Optional.ofNullable(partResult).map(r -> new CopyPartResult(r.getETag(), DateUtils.toLocalDateTime(partResult.getLastModifiedDate()), r.getVersionId(), r.getPartNumber())).orElseGet(CopyPartResult::new);
    }

    public static org.mule.extension.s3.api.model.CompleteMultipartUploadResult wrapCompleteMultipartUploadResult(CompleteMultipartUploadResult uploadResult) {
        return Optional.ofNullable(uploadResult).map(r -> new org.mule.extension.s3.api.model.CompleteMultipartUploadResult(uploadResult.getBucketName(), uploadResult.getKey(), uploadResult.getLocation(), uploadResult.getETag(), uploadResult.getVersionId(), DateUtils.toLocalDateTime(uploadResult.getExpirationTime()), uploadResult.getExpirationTimeRuleId())).orElseGet(org.mule.extension.s3.api.model.CompleteMultipartUploadResult::new);
    }

    public static org.mule.extension.s3.api.model.MultipartUploadListing wrapMultipartUploadListing(MultipartUploadListing multipartListing) {
        return Optional.ofNullable(multipartListing).map(m -> new org.mule.extension.s3.api.model.MultipartUploadListing(m.getBucketName(), m.getKeyMarker(), m.getDelimiter(), m.getPrefix(), m.getUploadIdMarker(), m.getMaxUploads(), m.getEncodingType(), m.isTruncated(), m.getNextKeyMarker(), m.getNextUploadIdMarker(), m.getMultipartUploads().stream().map(S3ModelFactory::transform).collect(Collectors.toList()), m.getCommonPrefixes())).orElseGet(org.mule.extension.s3.api.model.MultipartUploadListing::new);
    }

    private static MultipartUpload transform(com.amazonaws.services.s3.model.MultipartUpload upload) {
        return new MultipartUpload(upload.getKey(), upload.getUploadId(), S3ModelFactory.transform(upload.getOwner()), S3ModelFactory.transform(upload.getInitiator()), upload.getStorageClass(), DateUtils.toLocalDateTime(upload.getInitiated()));
    }

    public static PartListing wrapPartListing(com.amazonaws.services.s3.model.PartListing partListing) {
        return Optional.ofNullable(partListing).map(p -> new PartListing(p.getBucketName(), p.getKey(), p.getUploadId(), p.getMaxParts(), p.getPartNumberMarker(), p.getEncodingType(), S3ModelFactory.transform(p.getOwner()), S3ModelFactory.transform(p.getInitiator()), p.getStorageClass(), p.isTruncated(), p.getNextPartNumberMarker(), p.getParts().stream().map(S3ModelFactory::transform).collect(Collectors.toList()))).orElseGet(PartListing::new);
    }

    public static org.mule.extension.s3.api.model.PartSummary transform(PartSummary partSummary) {
        return new org.mule.extension.s3.api.model.PartSummary(partSummary.getPartNumber(), DateUtils.toLocalDateTime(partSummary.getLastModified()), partSummary.getETag(), partSummary.getSize());
    }

    public static S3VersionSummary transform(com.amazonaws.services.s3.model.S3VersionSummary versionSummary) {
        return new S3VersionSummary(versionSummary.getBucketName(), versionSummary.getKey(), versionSummary.getVersionId(), versionSummary.isLatest(), DateUtils.toLocalDateTime(versionSummary.getLastModified()), S3ModelFactory.transform(versionSummary.getOwner()), versionSummary.getETag(), versionSummary.getSize(), versionSummary.getStorageClass(), versionSummary.isDeleteMarker());
    }

    public static S3ObjectSummary transform(com.amazonaws.services.s3.model.S3ObjectSummary objectSummary) {
        return new S3ObjectSummary(objectSummary.getBucketName(), objectSummary.getKey(), objectSummary.getETag(), objectSummary.getSize(), DateUtils.toLocalDateTime(objectSummary.getLastModified()), objectSummary.getStorageClass(), S3ModelFactory.transform(objectSummary.getOwner()));
    }

    private static Owner transform(com.amazonaws.services.s3.model.Owner owner) {
        return Optional.ofNullable(owner).map(o -> new Owner(owner.getId(), owner.getDisplayName())).orElse(null);
    }
}

