/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.s3.internal.operation;

import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;
import org.mule.extension.s3.api.group.ObjectMetadataParameterGroup;
import org.mule.extension.s3.api.model.CannedAccessControlList;
import org.mule.extension.s3.api.model.CompleteMultipartUploadResult;
import org.mule.extension.s3.api.model.CopyPartResult;
import org.mule.extension.s3.api.model.MultipartUploadListing;
import org.mule.extension.s3.api.model.PartETag;
import org.mule.extension.s3.api.model.PartListing;
import org.mule.extension.s3.api.model.UploadPartResult;
import org.mule.extension.s3.internal.config.S3Configuration;
import org.mule.extension.s3.internal.connection.S3Connection;
import org.mule.extension.s3.internal.error.provider.S3ErrorTypeProvider;
import org.mule.extension.s3.internal.operation.S3Operations;
import org.mule.extension.s3.internal.service.ObjectIdentifier;
import org.mule.extension.s3.internal.service.UploadService;
import org.mule.extension.s3.internal.service.UploadServiceImpl;
import org.mule.extension.s3.internal.service.VersionedObjectIdentifier;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@Throws(value={S3ErrorTypeProvider.class})
public class UploadOperations
extends S3Operations<UploadService> {
    public UploadOperations() {
        super(UploadServiceImpl::new);
    }

    @MediaType(value="application/plain")
    public String initiateMultipartUpload(@Config S3Configuration config, @Connection S3Connection connection, String bucketName, String key, @Placement(order=9) @Summary(value="The additional information about the new object being created, such as content type & encoding, etc.") @Optional ObjectMetadataParameterGroup objectMetadata, @Summary(value="The optional canned Access Control List (ACL) to set permissions for the new object created when the multipart upload is completed.") @DisplayName(value="Canned ACL") @Optional(defaultValue="PRIVATE") CannedAccessControlList acl, @Optional String redirectLocation) {
        return (String)this.newExecutionBuilder(config, connection).execute(UploadService::initiateMultipartUpload).withParam((Object)new ObjectIdentifier(bucketName, key)).withParam((Object)objectMetadata).withParam((Object)acl).withParam((Object)redirectLocation);
    }

    public UploadPartResult uploadPart(@Config S3Configuration config, @Connection S3Connection connection, @Summary(value="The name of the bucket containing the existing, initiated multipart upload, with which this new part will be associated.") String bucketName, String key, @Summary(value="The ID of the existing, initiated multipart upload with which this new part will be associated.") String uploadId, @Summary(value="the part number describing this part's position relative to the other parts in the multipart upload.") Integer partNumber, Long partSize, @Optional String md5Digest, @Content InputStream content, @Summary(value="The optional offset in the specified file, at which to begin uploading data for this part.") @Optional Long fileOffset, @Summary(value="True if the creator of this request has indicated this part is the last part being uploaded in a multipart upload.") @Optional(defaultValue="false") boolean isLastPart) {
        return (UploadPartResult)this.newExecutionBuilder(config, connection).execute(UploadService::uploadPart).withParam((Object)new VersionedObjectIdentifier(bucketName, key, uploadId)).withParam((Object)partNumber).withParam((Object)partSize).withParam((Object)md5Digest).withParam((Object)content).withParam((Object)fileOffset).withParam((Object)isLastPart);
    }

    public CopyPartResult uploadPartCopy(@Config S3Configuration config, @Connection S3Connection connection, String sourceBucketName, String sourceKey, @Summary(value="The version of the source object that was copied, if you have enabled versioning on the source bucket.") @Optional String sourceVersionId, String destinationBucketName, String destinationKey, @Summary(value="The ID of the existing, initiated multipart upload with which this new part will be associated.") String uploadId, @Summary(value="The part number describing this part's position relative to the other parts in the multipart upload.") Integer partNumber, @Summary(value="Perform a copy if the source object entity tag (ETag) matches the specified value.") @DisplayName(value="Matching ETag Constraints") @Optional List<String> matchingETagConstraints, @Summary(value="The optional modified constraint that restricts this request to executing only if the source object has been modified after the specified date.") @Optional LocalDateTime modifiedSince, @Summary(value="The optional unmodified constraint that restricts this request to executing only if the source object has not been modified after the specified date.") @Optional LocalDateTime unmodifiedSince, @Summary(value="The optional first byte from the source bucket to start copy from (starts from 0).") @Optional Long firstByte, @Optional Long lastByte) {
        return (CopyPartResult)this.newExecutionBuilder(config, connection).execute(UploadService::uploadPartCopy).withParam((Object)new VersionedObjectIdentifier(sourceBucketName, sourceKey, sourceVersionId)).withParam((Object)new VersionedObjectIdentifier(destinationBucketName, destinationKey, uploadId)).withParam((Object)partNumber).withParam(matchingETagConstraints).withParam((Object)modifiedSince).withParam((Object)unmodifiedSince).withParam((Object)firstByte).withParam((Object)lastByte);
    }

    public void abortMultipartUpload(@Config S3Configuration config, @Connection S3Connection connection, String bucketName, String key, String uploadId) {
        this.newExecutionBuilder(config, connection).execute(UploadService::abortMultipartUpload).withParam((Object)new VersionedObjectIdentifier(bucketName, key, uploadId));
    }

    public CompleteMultipartUploadResult completeMultipartUpload(@Config S3Configuration config, @Connection S3Connection connection, String bucketName, String key, String uploadId, @Summary(value="The list of part numbers and ETags that identify the individual parts of the multipart upload to complete.") @Content @DisplayName(value="Part ETags") List<PartETag> partETags) {
        return (CompleteMultipartUploadResult)this.newExecutionBuilder(config, connection).execute(UploadService::completeMultipartUpload).withParam((Object)new VersionedObjectIdentifier(bucketName, key, uploadId)).withParam(partETags);
    }

    public MultipartUploadListing listMultipartUploads(@Config S3Configuration config, @Connection S3Connection connection, String bucketName, @Summary(value="The optional delimiter parameter that causes multipart uploads for keys that contain the same string between the prefix and the first occurrence of the delimiter to be combined into a single result element.") @Optional String delimiter, @Summary(value="The optional encodingType parameter indicating the encoding method to be applied on the response.") @Optional String encodingType, @Optional String keyMarker, @Summary(value="The optional maximum number of uploads to return, or null if no maximum number of uploads has been set for this request.") @Optional Integer maxUploads, @Summary(value="The optional prefix parameter that restricts the response to multipart uploads for keys that begin with the specified prefix.") @Optional String prefix, @Optional String uploadIdMarker) {
        return (MultipartUploadListing)this.newExecutionBuilder(config, connection).execute(UploadService::listMultipartUploads).withParam((Object)bucketName).withParam((Object)delimiter).withParam((Object)encodingType).withParam((Object)keyMarker).withParam((Object)maxUploads).withParam((Object)prefix).withParam((Object)uploadIdMarker);
    }

    public PartListing listParts(@Config S3Configuration config, @Connection S3Connection connection, @Summary(value="The name of the bucket containing the multipart upload whose parts are being listed.") String bucketName, String key, String uploadId, @Summary(value="The optional encodingType parameter indicating the encoding method to be applied on the response.") @Optional String encodingType, @Optional Integer maxParts, @Summary(value="The optional part number marker indicating where in the results to being listing parts.") @Optional Integer partNumberMarker) {
        return (PartListing)this.newExecutionBuilder(config, connection).execute(UploadService::listParts).withParam((Object)new VersionedObjectIdentifier(bucketName, key, uploadId)).withParam((Object)encodingType).withParam((Object)maxParts).withParam((Object)partNumberMarker);
    }
}

