/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.s3.internal.operation.paging;

import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.extension.s3.api.model.S3ObjectSummary;
import org.mule.extension.s3.internal.connection.S3Connection;
import org.mule.extension.s3.internal.operation.S3ModelFactory;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;

public class ObjectListPagingProvider
implements PagingProvider<S3Connection, S3ObjectSummary> {
    private final ListObjectsRequest request;
    private ObjectListing listing;

    public ObjectListPagingProvider(ListObjectsRequest request) {
        this.request = request;
    }

    public List<S3ObjectSummary> getPage(S3Connection connection) {
        this.listing = Optional.ofNullable(this.listing).map(connection::listNextBatchOfObjects).orElseGet(() -> connection.listObjects(this.request));
        return this.listing.getObjectSummaries().stream().map(S3ModelFactory::transform).collect(Collectors.toList());
    }

    public Optional<Integer> getTotalResults(S3Connection connection) {
        return Optional.ofNullable(null);
    }

    public void close(S3Connection connection) throws MuleException {
    }
}

